/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service.impl;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.jasig.portlet.blackboardvcportlet.dao.ConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.data.BasicUser;
import org.jasig.portlet.blackboardvcportlet.data.BasicUserImpl;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceSecurityUser;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceUserService;
import org.jasig.portlet.blackboardvcportlet.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ConferenceUserServiceImpl
implements ConferenceUserService {
    private static final Pattern NAME_NORMALIZER = Pattern.compile("\\s+");
    private ConferenceUserDao conferenceUserDao;
    private UserService userService;
    private Ehcache userServiceCache;

    @Autowired
    @Qualifier(value="userServiceCache")
    public void setEhcache(Ehcache ehcache) {
        this.userServiceCache = ehcache;
    }

    @Autowired(required=false)
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    public void setConferenceUserDao(ConferenceUserDao conferenceUserDao) {
        this.conferenceUserDao = conferenceUserDao;
    }

    @Override
    public ConferenceUser getCurrentConferenceUser() {
        Authentication authentication = this.getCurrentAuthentication();
        if (authentication == null) {
            return null;
        }
        return this.getConferenceUser(authentication);
    }

    @Override
    public Authentication getCurrentAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        return context.getAuthentication();
    }

    @Override
    public ConferenceUser getConferenceUser(Authentication authentication) {
        ConferenceSecurityUser principal = (ConferenceSecurityUser)((Object)authentication.getPrincipal());
        if (principal == null) {
            return null;
        }
        String uniqueId = principal.getUniqueId();
        return this.conferenceUserDao.getUserByUniqueId(uniqueId);
    }

    @Override
    public ConferenceUser getOrCreateConferenceUser(String displayName, String email) {
        return this.getOrCreateConferenceUser((BasicUser)new BasicUserImpl(null, email, displayName));
    }

    @Override
    public ConferenceUser getOrCreateConferenceUser(String uniqueId, String displayName, String email) {
        BasicUser basicUser;
        if (uniqueId != null && (basicUser = this.findBasicUser(uniqueId)) != null) {
            return this.getOrCreateConferenceUser(basicUser);
        }
        return this.getOrCreateConferenceUser((BasicUser)new BasicUserImpl(null, email, displayName));
    }

    @Override
    public ConferenceUser getOrCreateConferenceUser(BasicUser basicUser) {
        String uniqueId = basicUser.getUniqueId();
        if (uniqueId != null) {
            ConferenceUser user = this.conferenceUserDao.getUserByUniqueId(uniqueId);
            if (user != null) {
                return user;
            }
            user = this.conferenceUserDao.createInternalUser(uniqueId);
            user.setDisplayName(basicUser.getDisplayName());
            user.setEmail(basicUser.getEmail());
            user.getAdditionalEmails().addAll(basicUser.getAdditionalEmails());
            return user;
        }
        String email = basicUser.getEmail();
        Set users = this.conferenceUserDao.getUsersByPrimaryEmail(email);
        if (users.size() == 1) {
            return (ConferenceUser)DataAccessUtils.requiredSingleResult((Collection)users);
        }
        if (users.isEmpty() && (users = this.conferenceUserDao.getUsersByAnyEmail(email)).size() == 1) {
            return (ConferenceUser)DataAccessUtils.requiredSingleResult((Collection)users);
        }
        ConferenceUser user = this.conferenceUserDao.getExternalUserByEmail(email);
        if (user != null) {
            return user;
        }
        return this.conferenceUserDao.createExternalUser(basicUser.getDisplayName(), email);
    }

    @Override
    public BasicUser findBasicUser(String uniqueId) {
        ConferenceUser confUser = this.conferenceUserDao.getUserByUniqueId(uniqueId);
        if (confUser != null) {
            return confUser;
        }
        if (this.userService == null) {
            return null;
        }
        Serializable cacheKey = this.createUniqueIdCacheKey(uniqueId);
        Element element = this.userServiceCache.get(cacheKey);
        if (element != null) {
            return (BasicUser)element.getObjectValue();
        }
        BasicUser basicUser = this.userService.findUser(uniqueId);
        if (basicUser != null) {
            this.userServiceCache.put(new Element(cacheKey, (Serializable)basicUser));
        }
        return basicUser;
    }

    @Override
    public Set<BasicUser> searchForBasicUserByName(String name) {
        if (this.userService == null) {
            return Collections.emptySet();
        }
        String normalizedName = NAME_NORMALIZER.matcher(name.trim()).replaceAll(" ");
        Serializable cacheKey = this.createNameSearchCacheKey(normalizedName);
        Element element = this.userServiceCache.get(cacheKey);
        if (element != null) {
            return (Set)element.getObjectValue();
        }
        Set result = this.userService.searchForUserByName(normalizedName);
        this.userServiceCache.put(new Element((Object)cacheKey, (Object)result));
        this.cacheUsers(result);
        return result;
    }

    @Override
    public Set<BasicUser> searchForBasicUserByEmail(String email) {
        if (this.userService == null) {
            return Collections.emptySet();
        }
        String normalizedEmail = email.trim();
        Serializable cacheKey = this.createEmailSearchCacheKey(normalizedEmail);
        Element element = this.userServiceCache.get(cacheKey);
        if (element != null) {
            return (Set)element.getObjectValue();
        }
        Set result = this.userService.searchForUserByEmail(normalizedEmail);
        this.userServiceCache.put(new Element((Object)cacheKey, (Object)result));
        this.cacheUsers(result);
        return result;
    }

    private void cacheUsers(Set<BasicUser> result) {
        for (BasicUser user : result) {
            Serializable userCacheKey = this.createUniqueIdCacheKey(user.getUniqueId());
            this.userServiceCache.put(new Element(userCacheKey, (Serializable)user));
        }
    }

    private Serializable createUniqueIdCacheKey(String uniqueId) {
        return ImmutableMap.of((Object)"type", (Object)"findByUniqueId", (Object)"uniqueId", (Object)uniqueId.toUpperCase());
    }

    private Serializable createNameSearchCacheKey(String name) {
        return ImmutableMap.of((Object)"type", (Object)"searchByName", (Object)"name", (Object)name.toUpperCase());
    }

    private Serializable createEmailSearchCacheKey(String email) {
        return ImmutableMap.of((Object)"type", (Object)"searchByEmail", (Object)"email", (Object)email.toUpperCase());
    }
}

