/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service.impl;

import com.elluminate.sas.BlackboardRecordingLongResponse;
import com.elluminate.sas.BlackboardRecordingShortResponse;
import java.util.Collection;
import java.util.List;
import org.jasig.portlet.blackboardvcportlet.dao.SessionRecordingDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.RecordingWSDao;
import org.jasig.portlet.blackboardvcportlet.data.SessionRecording;
import org.jasig.portlet.blackboardvcportlet.service.RecordingService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ws.client.WebServiceClientException;

@Service(value="recordingService")
public class RecordingServiceImpl
implements RecordingService {
    private RecordingWSDao recordingWSDao;
    private SessionRecordingDao recordingDao;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public void setRecordingWSDao(RecordingWSDao recordingWSDao) {
        this.recordingWSDao = recordingWSDao;
    }

    @Autowired
    public void setRecordingDao(SessionRecordingDao dao) {
        this.recordingDao = dao;
    }

    public void updateSessionRecordings(long sessionId, long startTime, long endTime) {
        List recordingLongList = this.recordingWSDao.getRecordingLong(null, null, Long.valueOf(sessionId), null, Long.valueOf(startTime), Long.valueOf(endTime), null);
        BlackboardRecordingLongResponse recordingResponse = (BlackboardRecordingLongResponse)DataAccessUtils.singleResult((Collection)recordingLongList);
        this.recordingDao.createOrUpdateRecording(recordingResponse);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#recordingId, 'org.jasig.portlet.blackboardvcportlet.data.SessionRecording', 'view')")
    public SessionRecording getSessionRecording(long recordingId) {
        return this.recordingDao.getSessionRecording(recordingId);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#recordingId, 'org.jasig.portlet.blackboardvcportlet.data.SessionRecording', 'edit')")
    public void updateSessionRecordingName(long recordingId, String roomName) {
        SessionRecording sessionRecording = this.recordingDao.getSessionRecording(recordingId);
        sessionRecording.setRoomName(roomName);
        this.recordingDao.updateSessionRecording(sessionRecording);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#recordingId, 'org.jasig.portlet.blackboardvcportlet.data.SessionRecording', 'delete')")
    public void removeRecording(long recordingId) {
        SessionRecording sessionRecording;
        block3: {
            sessionRecording = this.recordingDao.getSessionRecording(recordingId);
            try {
                this.recordingWSDao.removeRecording(sessionRecording.getBbRecordingId());
            }
            catch (WebServiceClientException e) {
                List recordings = this.recordingWSDao.getRecordingShort(null, null, Long.valueOf(sessionRecording.getSession().getBbSessionId()), null, null, null, null);
                boolean exists = false;
                for (BlackboardRecordingShortResponse recording : recordings) {
                    if (recording.getRecordingId() != sessionRecording.getBbRecordingId()) continue;
                    exists = true;
                    break;
                }
                if (!exists) break block3;
                throw e;
            }
        }
        this.recordingDao.deleteRecording(sessionRecording);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public int datafixRecordings(DateTime startDate, DateTime endDate) {
        int countErred = 0;
        List recordingLongList = this.recordingWSDao.getRecordingLong(null, null, null, null, Long.valueOf(startDate.getMillis()), Long.valueOf(endDate.getMillis()), null);
        for (BlackboardRecordingLongResponse recordingResponse : recordingLongList) {
            try {
                this.recordingDao.createOrUpdateRecording(recordingResponse);
            }
            catch (Exception ex) {
                this.logger.error("Error adding datafix for recording: " + recordingResponse.getRecordingId() + " for session : " + recordingResponse.getSessionId(), (Throwable)ex);
                ++countErred;
            }
        }
        return countErred;
    }
}

