/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service.impl;

import org.jasig.portlet.blackboardvcportlet.dao.ServerQuotaDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.GlobalSettingsWSDao;
import org.jasig.portlet.blackboardvcportlet.data.ServerQuota;
import org.jasig.portlet.blackboardvcportlet.service.ServerQuotaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ServerQuotaServiceImpl
implements ServerQuotaService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServerQuotaDao serverQuotaDao;
    private GlobalSettingsWSDao globalSettingsWSDao;

    @Autowired
    public void setServerQuotaDao(ServerQuotaDao serverQuotaDao) {
        this.serverQuotaDao = serverQuotaDao;
    }

    @Autowired
    public void setGlobalSettingWSDao(GlobalSettingsWSDao value) {
        this.globalSettingsWSDao = value;
    }

    public ServerQuota getServerQuota() {
        ServerQuota serverQuota = this.serverQuotaDao.getServerQuota();
        if (serverQuota == null) {
            serverQuota = this.refreshServerQuota();
        }
        return serverQuota;
    }

    @Scheduled(fixedRate=86400000L)
    public void scheduledRefreshServerQuota() {
        this.refreshServerQuota();
    }

    public ServerQuota refreshServerQuota() {
        ServerQuota serverQuota = this.serverQuotaDao.getServerQuota();
        if (serverQuota != null && serverQuota.getLastUpdated().plusWeeks(1).isAfterNow()) {
            return serverQuota;
        }
        this.logger.info("Server Quota being refreshed");
        try {
            return this.serverQuotaDao.createOrUpdateQuota(this.globalSettingsWSDao.getServerQuota());
        }
        catch (Exception ex) {
            this.logger.error("Failed to refresh ServerQuota", (Throwable)ex);
            return null;
        }
    }
}

