/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service.impl;

import com.elluminate.sas.BlackboardMultimediaResponse;
import com.elluminate.sas.BlackboardPresentationResponse;
import com.elluminate.sas.BlackboardSessionResponse;
import com.elluminate.sas.BlackboardSessionTelephonyResponse;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jasig.portlet.blackboardvcportlet.dao.ConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.dao.MultimediaDao;
import org.jasig.portlet.blackboardvcportlet.dao.PresentationDao;
import org.jasig.portlet.blackboardvcportlet.dao.SessionDao;
import org.jasig.portlet.blackboardvcportlet.dao.SessionTelephonyDao;
import org.jasig.portlet.blackboardvcportlet.dao.UserSessionUrlDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.MultimediaWSDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.PresentationWSDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.SessionWSDao;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Multimedia;
import org.jasig.portlet.blackboardvcportlet.data.Presentation;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.data.SessionTelephony;
import org.jasig.portlet.blackboardvcportlet.data.UserSessionUrl;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceUserService;
import org.jasig.portlet.blackboardvcportlet.service.MailTemplateService;
import org.jasig.portlet.blackboardvcportlet.service.SessionForm;
import org.jasig.portlet.blackboardvcportlet.service.SessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.oxm.XmlMappingException;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.WebUtils;
import org.springframework.ws.client.WebServiceClientException;

@Service
public class SessionServiceImpl
implements SessionService,
ServletContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConferenceUserService conferenceUserService;
    private ConferenceUserDao conferenceUserDao;
    private SessionDao sessionDao;
    private MultimediaDao multimediaDao;
    private PresentationDao presentationDao;
    private SessionWSDao sessionWSDao;
    private MultimediaWSDao multimediaWSDao;
    private PresentationWSDao presentationWSDao;
    private MailTemplateService mailService;
    private SessionTelephonyDao sessionTelephonyDao;
    private File tempDir;
    private UserSessionUrlDao userSessionUrlDao;

    @Autowired
    public void setMailTemplateService(MailTemplateService mailService) {
        this.mailService = mailService;
    }

    @Autowired
    public void setUserSessionUrlDao(UserSessionUrlDao dao) {
        this.userSessionUrlDao = dao;
    }

    @Autowired
    public void setPresentationDao(PresentationDao presentationDao) {
        this.presentationDao = presentationDao;
    }

    @Autowired
    public void setMultimediaDao(MultimediaDao multimediaDao) {
        this.multimediaDao = multimediaDao;
    }

    @Autowired
    public void setConferenceUserDao(ConferenceUserDao conferenceUserDao) {
        this.conferenceUserDao = conferenceUserDao;
    }

    @Autowired
    public void setConferenceUserService(ConferenceUserService conferenceUserService) {
        this.conferenceUserService = conferenceUserService;
    }

    @Autowired
    public void setSessionDao(SessionDao sessionDao) {
        this.sessionDao = sessionDao;
    }

    @Autowired
    public void setSessionWSDao(SessionWSDao value) {
        this.sessionWSDao = value;
    }

    @Autowired
    public void setMultimediaWSDao(MultimediaWSDao multimediaWSDao) {
        this.multimediaWSDao = multimediaWSDao;
    }

    @Autowired
    public void setPresentationWSDao(PresentationWSDao presentationWSDao) {
        this.presentationWSDao = presentationWSDao;
    }

    @Autowired
    public void setSessionTelephonyDao(SessionTelephonyDao dao) {
        this.sessionTelephonyDao = dao;
    }

    public void setServletContext(ServletContext servletContext) {
        this.tempDir = WebUtils.getTempDir((ServletContext)servletContext);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    @PostFilter(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'edit')")
    public Set<ConferenceUser> getSessionChairs(Session session) {
        return new LinkedHashSet<ConferenceUser>(this.sessionDao.getSessionChairs(session));
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    public boolean isSessionParticipant(Session session, ConferenceUser user) {
        ConferenceUser userFromDB = this.conferenceUserDao.getUser(user.getUserId());
        return this.sessionDao.getSessionChairs(session).contains(userFromDB) || this.sessionDao.getSessionNonChairs(session).contains(userFromDB);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    @Transactional
    public String getOrCreateSessionUrl(ConferenceUser user, Session session) {
        return this.getOrCreateSessionUrl(user, session, false);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    @Transactional
    public String getOrCreateSessionUrl(ConferenceUser user, Session session, boolean forceFetch) {
        UserSessionUrl url = null;
        if (!forceFetch) {
            url = this.userSessionUrlDao.getUserSessionUrlsBySessionAndUser(session, user);
        }
        if (url == null) {
            String urlString = this.sessionWSDao.buildSessionUrl(session.getBbSessionId(), user);
            url = this.userSessionUrlDao.createUserSessionUrl(session, user, urlString);
        }
        return url.getUrl();
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    @Transactional
    public void deleteSessionUrl(ConferenceUser user, Session session) {
        this.userSessionUrlDao.deleteOldSessionUrls(session, user);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    public void populateLaunchUrl(ConferenceUser user, Session session) {
        if (this.isSessionParticipant(session, user)) {
            session.setLaunchUrl(this.getOrCreateSessionUrl(user, session));
        } else {
            session.setLaunchUrl(session.getGuestUrl());
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    @PostFilter(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'edit')")
    public Set<ConferenceUser> getSessionNonChairs(Session session) {
        return new LinkedHashSet<ConferenceUser>(this.sessionDao.getSessionNonChairs(session));
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    @PostFilter(value="hasRole('ROLE_ADMIN') || (hasRole('ROLE_FULL_ACCESS') && hasPermission(#session, 'edit'))")
    public Set<Multimedia> getSessionMultimedia(Session session) {
        return new LinkedHashSet<Multimedia>(this.sessionDao.getSessionMultimedias(session));
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'view')")
    public Session getSession(long sessionId) {
        return this.sessionDao.getSession(sessionId);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Set<Session> getAllSessions() {
        return this.sessionDao.getAllSessions();
    }

    @Transactional(noRollbackFor={WebServiceClientException.class, XmlMappingException.class})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSession(long sessionId) {
        Session session = this.sessionDao.getSession(sessionId);
        Set multimedias = this.sessionDao.getSessionMultimedias(session);
        for (Multimedia multimedia : multimedias) {
            this.removeMultimediaFromSession(session, null, multimedia);
        }
        this.deletePresentation(session.getSessionId());
        this.mailService.buildAndSendCancelationMeetingEmail(session);
        this.sessionWSDao.deleteSession(session.getBbSessionId());
        this.sessionDao.deleteSession(session);
    }

    private void removeMultimediaFromSession(Session session, Set<Long> bbMultimediaIds, Multimedia multimedia) {
        block5: {
            if (bbMultimediaIds != null) {
                if (bbMultimediaIds.contains(multimedia.getBbMultimediaId())) {
                    this.multimediaWSDao.removeSessionMultimedia(session.getBbSessionId(), multimedia.getBbMultimediaId());
                }
            } else {
                this.multimediaWSDao.removeSessionMultimedia(session.getBbSessionId(), multimedia.getBbMultimediaId());
            }
            this.sessionDao.deleteMultimediaFromSession(session, multimedia);
            try {
                this.multimediaWSDao.removeRepositoryMultimedia(multimedia.getBbMultimediaId());
            }
            catch (WebServiceClientException e) {
                List userMultimedias = this.multimediaWSDao.getRepositoryMultimedias(null, Long.valueOf(multimedia.getBbMultimediaId()), null);
                if (userMultimedias.isEmpty()) break block5;
                throw e;
            }
        }
        this.multimediaDao.deleteMultimedia(multimedia);
    }

    @Transactional
    @PreAuthorize(value="#sessionForm.newSession || hasRole('ROLE_ADMIN') || hasPermission(#sessionForm.sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public Session createOrUpdateSession(ConferenceUser user, SessionForm sessionForm) {
        Session session;
        if (sessionForm.isNewSession()) {
            BlackboardSessionResponse sessionResponse = this.sessionWSDao.createSession(user, sessionForm);
            String guestUrl = this.sessionWSDao.buildGuestSessionUrl(sessionResponse.getSessionId());
            session = this.sessionDao.createSession(sessionResponse, guestUrl);
            this.mailService.buildAndSendSessionEmails(session, false, true);
        } else {
            session = this.sessionDao.getSession(sessionForm.getSessionId());
            BlackboardSessionResponse sessionResponse = this.sessionWSDao.updateSession(session.getBbSessionId(), sessionForm);
            boolean isTimeChange = session.getStartTime().getMillis() != sessionResponse.getStartTime() || session.getEndTime().getMillis() != sessionResponse.getEndTime();
            this.sessionDao.updateSession(sessionResponse);
            if (isTimeChange) {
                this.mailService.buildAndSendSessionEmails(session, true, sessionForm.isNeedToSendInitialEmail());
            }
        }
        return session;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public ConferenceUser addSessionChair(long sessionId, String displayName, String email) {
        ConferenceUser newSessionChair = this.conferenceUserService.getOrCreateConferenceUser(displayName, email);
        this.addSessionChair(sessionId, newSessionChair, true);
        return newSessionChair;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public ConferenceUser updateRole(long sessionId, long userId, ConferenceUser.Roles newRole) {
        ConferenceUser user = this.conferenceUserDao.getUser(userId);
        Session session = this.sessionDao.getSession(sessionId);
        this.deleteSessionUrl(user, session);
        if (ConferenceUser.Roles.CHAIR.equals((Object)newRole)) {
            this.removeSessionNonChairs(sessionId, false, userId);
            this.addSessionChair(sessionId, user, false);
        } else {
            this.removeSessionChairs(sessionId, false, userId);
            this.addSessionNonChair(sessionId, user, false);
        }
        this.mailService.sendEmail(this.mailService.buildSwitchRolesEmail(user, session, newRole));
        return user;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public ConferenceUser addSessionChair(long sessionId, long userId, boolean sendEmail) {
        ConferenceUser user = this.conferenceUserDao.getUser(userId);
        if (user != null) {
            this.addSessionChair(sessionId, user, sendEmail);
        }
        return user;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public ConferenceUser addSessionChair(long sessionId, long userId) {
        return this.addSessionChair(sessionId, userId, true);
    }

    private void addSessionChair(long sessionId, ConferenceUser user, boolean sendEmail) {
        Assert.notNull((Object)user, (String)"user must not be null");
        Session session = this.sessionDao.getSession(sessionId);
        LinkedHashSet<ConferenceUser> sessionChairs = new LinkedHashSet<ConferenceUser>(this.getSessionChairs(session));
        sessionChairs.add(user);
        BlackboardSessionResponse sessionResponse = this.sessionWSDao.setSessionChairs(session.getBbSessionId(), sessionChairs);
        this.sessionDao.updateSession(sessionResponse);
        if (sendEmail) {
            this.mailService.sendEmail(this.mailService.buildModeratorMailTask(user, session, false));
        }
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSessionChairs(long sessionId, boolean sendEmail, long ... userIds) {
        Set users = this.conferenceUserDao.getUsers(userIds);
        this.removeSessionChairs(sessionId, users, sendEmail);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSessionChairs(long sessionId, long ... userIds) {
        this.removeSessionChairs(sessionId, true, userIds);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSessionChairs(long sessionId, Iterable<ConferenceUser> users) {
        this.removeSessionChairs(sessionId, users, true);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSessionChairs(long sessionId, Iterable<ConferenceUser> users, boolean sendCancelEmail) {
        Session session = this.sessionDao.getSession(sessionId);
        LinkedHashSet<ConferenceUser> sessionChairs = new LinkedHashSet<ConferenceUser>(this.getSessionChairs(session));
        for (ConferenceUser user : users) {
            boolean madeChange = sessionChairs.remove(user);
            if (!madeChange || !sendCancelEmail) continue;
            this.mailService.sendEmail(this.mailService.buildCancellationNoticeMailTask(user, session));
        }
        if (sessionChairs.isEmpty()) {
            this.sessionWSDao.clearSessionChairList(session.getBbSessionId());
            this.sessionDao.clearSessionUserList(session.getSessionId(), true);
        } else {
            BlackboardSessionResponse sessionResponse = this.sessionWSDao.setSessionChairs(session.getBbSessionId(), sessionChairs);
            this.sessionDao.updateSession(sessionResponse);
        }
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public ConferenceUser addSessionNonChair(long sessionId, String displayName, String email) {
        ConferenceUser newSessionNonChair = this.conferenceUserService.getOrCreateConferenceUser(displayName, email);
        this.addSessionNonChair(sessionId, newSessionNonChair, true);
        return newSessionNonChair;
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public ConferenceUser addSessionNonChair(long sessionId, long userId) {
        ConferenceUser user = this.conferenceUserDao.getUser(userId);
        if (user != null) {
            this.addSessionNonChair(sessionId, user, true);
        }
        return user;
    }

    private void addSessionNonChair(long sessionId, ConferenceUser user, boolean sendEmail) {
        Assert.notNull((Object)user, (String)"user must not be null");
        Session session = this.sessionDao.getSession(sessionId);
        LinkedHashSet<ConferenceUser> sessionNonChairs = new LinkedHashSet<ConferenceUser>(this.getSessionNonChairs(session));
        sessionNonChairs.add(user);
        BlackboardSessionResponse sessionResponse = this.sessionWSDao.setSessionNonChairs(session.getBbSessionId(), sessionNonChairs);
        this.sessionDao.updateSession(sessionResponse);
        if (sendEmail) {
            this.mailService.sendEmail(this.mailService.buildParticipantMailTask(user, session, false));
        }
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSessionNonChairs(long sessionId, long ... userIds) {
        Set users = this.conferenceUserDao.getUsers(userIds);
        this.removeSessionNonChairs(sessionId, users);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSessionNonChairs(long sessionId, boolean sendEmail, long ... userIds) {
        Set users = this.conferenceUserDao.getUsers(userIds);
        this.removeSessionNonChairs(sessionId, users, sendEmail);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSessionNonChairs(long sessionId, Iterable<ConferenceUser> users) {
        this.removeSessionNonChairs(sessionId, users, true);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void removeSessionNonChairs(long sessionId, Iterable<ConferenceUser> users, boolean sendEmail) {
        Session session = this.sessionDao.getSession(sessionId);
        LinkedHashSet<ConferenceUser> sessionNonChairs = new LinkedHashSet<ConferenceUser>(this.getSessionNonChairs(session));
        for (ConferenceUser user : users) {
            boolean madeChange = sessionNonChairs.remove(user);
            if (!madeChange || !sendEmail) continue;
            this.mailService.sendEmail(this.mailService.buildCancellationNoticeMailTask(user, session));
        }
        if (sessionNonChairs.isEmpty()) {
            this.sessionWSDao.clearSessionNonChairList(session.getBbSessionId());
            this.sessionDao.clearSessionUserList(session.getSessionId(), false);
        } else {
            BlackboardSessionResponse sessionResponse = this.sessionWSDao.setSessionNonChairs(session.getBbSessionId(), sessionNonChairs);
            this.sessionDao.updateSession(sessionResponse);
        }
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || (hasRole('ROLE_FULL_ACCESS') && hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit'))")
    public void addMultimedia(long sessionId, MultipartFile file) {
        Session session = this.sessionDao.getSession(sessionId);
        ConferenceUser conferenceUser = this.conferenceUserService.getCurrentConferenceUser();
        BlackboardMultimediaResponse multimediaResponse = this.createSessionMultimedia(session, conferenceUser, file);
        String filename = FilenameUtils.getName((String)file.getOriginalFilename());
        Multimedia multimedia = this.multimediaDao.createMultimedia(multimediaResponse, filename);
        this.sessionDao.addMultimediaToSession(session, multimedia);
    }

    @Transactional(noRollbackFor={WebServiceClientException.class, XmlMappingException.class})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || (hasRole('ROLE_FULL_ACCESS') && hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit'))")
    public void deleteMultimedia(long sessionId, long ... multimediaIds) {
        Session session = this.sessionDao.getSession(sessionId);
        Set<Long> bbMultimediaIds = this.getBlackboardMultimediaIds(session);
        for (long multimediaId : multimediaIds) {
            Multimedia multimedia = this.multimediaDao.getMultimediaById(multimediaId);
            this.removeMultimediaFromSession(session, bbMultimediaIds, multimedia);
        }
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || (hasRole('ROLE_FULL_ACCESS') && hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit'))")
    public void addPresentation(long sessionId, MultipartFile file) {
        Session session = this.sessionDao.getSession(sessionId);
        if (session.getPresentation() != null) {
            this.deletePresentation(session.getSessionId());
        }
        ConferenceUser conferenceUser = this.conferenceUserService.getCurrentConferenceUser();
        BlackboardPresentationResponse presentationResponse = this.createSessionPresentation(session, conferenceUser, file);
        String filename = FilenameUtils.getName((String)file.getOriginalFilename());
        Presentation presentation = this.presentationDao.createPresentation(presentationResponse, filename);
        this.sessionDao.addPresentationToSession(session, presentation);
    }

    @Transactional
    @PreAuthorize(value="hasRole('ROLE_ADMIN') || (hasRole('ROLE_FULL_ACCESS') && hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit'))")
    public void deletePresentation(long sessionId) {
        Presentation presentation;
        block6: {
            Session session;
            block5: {
                session = this.sessionDao.getSession(sessionId);
                presentation = session.getPresentation();
                if (presentation == null) {
                    return;
                }
                try {
                    this.presentationWSDao.deleteSessionPresenation(session.getBbSessionId(), presentation.getBbPresentationId());
                }
                catch (WebServiceClientException e) {
                    List sessionPresentations = this.presentationWSDao.getSessionPresentations(session.getBbSessionId());
                    if (sessionPresentations.isEmpty()) break block5;
                    throw e;
                }
            }
            this.sessionDao.removePresentationFromSession(session);
            try {
                this.presentationWSDao.deletePresentation(presentation.getBbPresentationId());
            }
            catch (WebServiceClientException e) {
                ConferenceUser creator = session.getCreator();
                List repositoryPresentations = this.presentationWSDao.getRepositoryPresentations(creator.getUniqueId(), Long.valueOf(presentation.getBbPresentationId()), null);
                if (repositoryPresentations.isEmpty()) break block6;
                throw e;
            }
        }
        this.presentationDao.deletePresentation(presentation);
    }

    private Set<Long> getBlackboardMultimediaIds(Session session) {
        List multimedias = this.multimediaWSDao.getSessionMultimedias(session.getBbSessionId());
        Iterator multimediasItr = multimedias.iterator();
        return ImmutableSet.copyOf((Iterator)Iterators.transform(multimediasItr, (Function)new Function<BlackboardMultimediaResponse, Long>(){

            public Long apply(BlackboardMultimediaResponse r) {
                return r.getMultimediaId();
            }
        }));
    }

    private BlackboardMultimediaResponse createSessionMultimedia(Session session, ConferenceUser conferenceUser, MultipartFile file) {
        BlackboardMultimediaResponse blackboardMultimediaResponse;
        String filename = FilenameUtils.getName((String)file.getOriginalFilename());
        File multimediaFile = null;
        try {
            multimediaFile = File.createTempFile(filename, ".tmp", this.tempDir);
            file.transferTo(multimediaFile);
            blackboardMultimediaResponse = this.multimediaWSDao.createSessionMultimedia(session.getBbSessionId(), conferenceUser.getUniqueId(), filename, "", new DataHandler((DataSource)new FileDataSource(multimediaFile)));
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to upload multimedia file '" + filename + "'", e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(multimediaFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)multimediaFile);
        return blackboardMultimediaResponse;
    }

    private BlackboardPresentationResponse createSessionPresentation(Session session, ConferenceUser conferenceUser, MultipartFile file) {
        BlackboardPresentationResponse blackboardPresentationResponse;
        String filename = FilenameUtils.getName((String)file.getOriginalFilename());
        File multimediaFile = null;
        try {
            multimediaFile = File.createTempFile(filename, ".tmp", this.tempDir);
            file.transferTo(multimediaFile);
            blackboardPresentationResponse = this.presentationWSDao.uploadPresentation(session.getBbSessionId(), conferenceUser.getUniqueId(), filename, "", new DataHandler((DataSource)new FileDataSource(multimediaFile)));
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to upload multimedia file '" + filename + "'", e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(multimediaFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)multimediaFile);
        return blackboardPresentationResponse;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#session, 'view')")
    public SessionTelephony getSessionTelephony(Session session) {
        return this.sessionTelephonyDao.getSessionTelephony(session);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void createOrUpdateSessionTelephony(long sessionId, SessionTelephony telephony) {
        Session session = this.getSession(sessionId);
        BlackboardSessionTelephonyResponse response = this.sessionWSDao.createSessionTelephony(session.getBbSessionId(), telephony);
        this.sessionTelephonyDao.createOrUpdateTelephony(response);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') || hasPermission(#sessionId, 'org.jasig.portlet.blackboardvcportlet.data.Session', 'edit')")
    public void deleteSessionTelephony(long sessionId) {
        Session session = this.getSession(sessionId);
        this.sessionWSDao.removeSessionTelephony(session.getBbSessionId());
        this.sessionTelephonyDao.deleteTelephony(sessionId);
    }
}

