/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service.util;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.TransformerException;
import org.jasig.portlet.blackboardvcportlet.service.util.SASWebServiceOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.saaj.SaajSoapMessage;

public class SASWebServiceTemplate
extends WebServiceTemplate
implements SASWebServiceOperations {
    private Jaxb2Marshaller elluminateMarshller;
    private String username;
    private String password;

    @Autowired
    public void setElluminateMarshller(Jaxb2Marshaller elluminateMarshller) {
        this.elluminateMarshller = elluminateMarshller;
    }

    public SASWebServiceTemplate(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public Object marshalSendAndReceiveToSAS(final String soapAction, Object requestPayload) {
        return this.marshalSendAndReceive(requestPayload, new WebServiceMessageCallback(){

            public void doWithMessage(WebServiceMessage webServiceMessage) throws IOException, TransformerException {
                if (webServiceMessage instanceof SaajSoapMessage) {
                    SaajSoapMessage casted = (SaajSoapMessage)webServiceMessage;
                    casted.setSoapAction(soapAction);
                    QName qName = new QName(SASWebServiceTemplate.this.elluminateMarshller.getContextPath(), "BasicAuth", "sas");
                    try {
                        SOAPElement baHeader = casted.getSaajMessage().getSOAPHeader().addChildElement(qName);
                        baHeader.addChildElement(new QName("sas", "Name")).addTextNode(SASWebServiceTemplate.this.username);
                        baHeader.addChildElement(new QName("sas", "Password")).addTextNode(SASWebServiceTemplate.this.password);
                    }
                    catch (Exception e) {
                        SASWebServiceTemplate.this.logger.error((Object)"Error creating SOAPHeader: ", (Throwable)e);
                    }
                }
            }
        });
    }
}

