/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.jpa;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jasig.jpa.CacheKey;
import org.jasig.jpa.OpenEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Aspect
@Component(value="openEntityManagerAspect")
public class OpenEntityManagerAspect
implements ApplicationContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<CacheKey, EntityManagerFactory> entityManagerFactories = new ConcurrentHashMap();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Pointcut(value="execution(public * *(..))")
    public void anyPublicMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="anyPublicMethod() && @annotation(openEntityManager)")
    public Object openEntityManager(ProceedingJoinPoint pjp, OpenEntityManager openEntityManager) throws Throwable {
        EntityManagerFactory emf = this.getEntityManagerFactory(openEntityManager);
        EntityManager em = this.getTransactionalEntityManager(emf);
        boolean isNewEm = false;
        if (em == null) {
            this.logger.debug("Opening JPA EntityManager in OpenEntityManagerAspect");
            em = this.createEntityManager(emf);
            isNewEm = true;
            TransactionSynchronizationManager.bindResource((Object)emf, (Object)new EntityManagerHolder(em));
        } else {
            this.logger.debug("Using Existing JPA EntityManager in OpenEntityManagerAspect");
        }
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            if (isNewEm) {
                this.logger.debug("Closing JPA EntityManager in OpenEntityManagerAspect");
                TransactionSynchronizationManager.unbindResource((Object)emf);
                EntityManagerFactoryUtils.closeEntityManager((EntityManager)em);
            }
        }
    }

    protected EntityManager getTransactionalEntityManager(EntityManagerFactory emf) throws IllegalStateException {
        Assert.state((emf != null ? 1 : 0) != 0, (String)"No EntityManagerFactory specified");
        return EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)emf);
    }

    protected EntityManagerFactory getEntityManagerFactory(OpenEntityManager openEntityManager) {
        CacheKey key = this.createEntityManagerFactoryKey(openEntityManager);
        EntityManagerFactory emf = (EntityManagerFactory)this.entityManagerFactories.get(key);
        if (emf == null) {
            emf = this.lookupEntityManagerFactory(openEntityManager);
            this.entityManagerFactories.put(key, emf);
        }
        return emf;
    }

    protected EntityManagerFactory lookupEntityManagerFactory(OpenEntityManager openEntityManager) {
        String emfBeanName = openEntityManager.name();
        String puName = openEntityManager.unitName();
        if (StringUtils.hasLength((String)emfBeanName)) {
            return (EntityManagerFactory)this.applicationContext.getBean(emfBeanName, EntityManagerFactory.class);
        }
        if (!StringUtils.hasLength((String)puName) && this.applicationContext.containsBean("entityManagerFactory")) {
            return (EntityManagerFactory)this.applicationContext.getBean("entityManagerFactory", EntityManagerFactory.class);
        }
        return EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)this.applicationContext, (String)puName);
    }

    protected EntityManager createEntityManager(EntityManagerFactory emf) {
        return emf.createEntityManager();
    }

    protected final CacheKey createEntityManagerFactoryKey(OpenEntityManager openEntityManager) {
        return CacheKey.build((String)"", (Serializable[])new Serializable[]{openEntityManager.name(), openEntityManager.unitName()});
    }
}

