/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.Validate;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.jpa.OpenEntityManager;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl_;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Multimedia;
import org.jasig.portlet.blackboardvcportlet.data.Presentation;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ConferenceUserDaoImpl
extends BaseJpaDao
implements InternalConferenceUserDao {
    private ParameterExpression<String> emailParameter;
    private CriteriaQuery<ConferenceUserImpl> getUsersByPrimaryEmailQuery;
    private CriteriaQuery<ConferenceUserImpl> getUsersByAnyEmailQuery;

    public void afterPropertiesSet() throws Exception {
        this.emailParameter = this.createParameterExpression(String.class, "email");
        this.getUsersByPrimaryEmailQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
        this.getUsersByAnyEmailQuery = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Set<Session> getOwnedSessionsForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        if (userImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf((Collection)userImpl.getOwnedSessions());
    }

    public Set<Session> getChairedSessionsForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        if (userImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf((Collection)userImpl.getChairedSessions());
    }

    public Set<Session> getNonChairedSessionsForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        if (userImpl == null) {
            return null;
        }
        return ImmutableSet.copyOf((Collection)userImpl.getNonChairedSessions());
    }

    @Transactional
    public ConferenceUserImpl createInternalUser(String uniqueId) {
        ConferenceUserImpl user = new ConferenceUserImpl(uniqueId);
        this.getEntityManager().persist((Object)user);
        return user;
    }

    @Transactional
    public ConferenceUserImpl createExternalUser(String displayName, String email) {
        String invitationToken = RandomStringUtils.randomAlphanumeric((int)20);
        ConferenceUserImpl user = new ConferenceUserImpl(email, invitationToken);
        user.setDisplayName(displayName);
        this.getEntityManager().persist((Object)user);
        return user;
    }

    @Transactional
    public ConferenceUserImpl createExternalUser(String email) {
        return this.createExternalUser(null, email);
    }

    public Set<Multimedia> getMultimediasForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        return ImmutableSet.copyOf((Collection)userImpl.getMultimedias());
    }

    public Set<Presentation> getPresentationsForUser(ConferenceUser user) {
        if (user == null) {
            return null;
        }
        ConferenceUserImpl userImpl = this.getUser(user.getUserId());
        return ImmutableSet.copyOf((Collection)userImpl.getPresentations());
    }

    @Transactional
    public ConferenceUser updateUser(ConferenceUser user) {
        Validate.notNull((Object)user, (String)"user can not be null");
        this.getEntityManager().persist((Object)user);
        return user;
    }

    @Transactional
    public void deleteUser(ConferenceUser user) {
        Validate.notNull((Object)user, (String)"user can not be null");
        EntityManager entityManager = this.getEntityManager();
        if (!entityManager.contains((Object)user)) {
            user = (ConferenceUser)entityManager.merge((Object)user);
        }
        entityManager.remove((Object)user);
    }

    public ConferenceUserImpl getUser(long userId) {
        EntityManager entityManager = this.getEntityManager();
        return (ConferenceUserImpl)entityManager.find(ConferenceUserImpl.class, (Object)userId);
    }

    public Set<ConferenceUser> getUsers(long ... userIds) {
        HashSet<ConferenceUser> users = new HashSet<ConferenceUser>();
        for (long userId : userIds) {
            ConferenceUserImpl user = this.getUser(userId);
            if (user == null) continue;
            users.add((ConferenceUser)user);
        }
        return users;
    }

    @OpenEntityManager
    public ConferenceUserImpl getUserByUniqueId(String uniqueId) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(ConferenceUserImpl.class);
        query.using((Attribute)ConferenceUserImpl_.uniqueId, (Object)uniqueId.toUpperCase());
        query.using((Attribute)ConferenceUserImpl_.external, (Object)false);
        return (ConferenceUserImpl)query.load();
    }

    @OpenEntityManager
    public ConferenceUserImpl getExternalUserByEmail(String email) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(ConferenceUserImpl.class);
        query.using((Attribute)ConferenceUserImpl_.uniqueId, (Object)email.toUpperCase());
        query.using((Attribute)ConferenceUserImpl_.external, (Object)true);
        return (ConferenceUserImpl)query.load();
    }

    public Set<ConferenceUser> getUsersByAnyEmail(String email) {
        TypedQuery query = this.createQuery(this.getUsersByAnyEmailQuery);
        query.setParameter((Parameter)this.emailParameter, (Object)email.toUpperCase());
        List resultList = query.getResultList();
        return new LinkedHashSet<ConferenceUser>(resultList);
    }

    public Set<ConferenceUser> getUsersByPrimaryEmail(String email) {
        TypedQuery query = this.createQuery(this.getUsersByPrimaryEmailQuery);
        query.setParameter((Parameter)this.emailParameter, (Object)email.toUpperCase());
        List resultList = query.getResultList();
        return new LinkedHashSet<ConferenceUser>(resultList);
    }

    static /* synthetic */ ParameterExpression access$000(ConferenceUserDaoImpl x0) {
        return x0.emailParameter;
    }
}

