/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Multimedia;
import org.joda.time.DateTime;

@Entity
@Table(name="VC2_MULTIMEDIA")
@SequenceGenerator(name="VC2_MULTIMEDIA_GEN", sequenceName="VC2_MULTIMEDIA_SEQ", allocationSize=10)
@TableGenerator(name="VC2_MULTIMEDIA_GEN", pkColumnValue="VC2_MULTIMEDIA", allocationSize=10)
@NaturalIdCache
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class MultimediaImpl
implements Multimedia {
    @Id
    @GeneratedValue(generator="VC2_MULTIMEDIA_GEN")
    @Column(name="MULTIMEDIA_ID", nullable=false)
    private final long multimediaId;
    @Version
    @Column(name="ENTITY_VERSION")
    private final long entityVersion;
    @NaturalId
    @Column(name="BB_MULTIMEDIA_ID", nullable=false)
    private final long bbMultimediaId;
    @ManyToOne(targetEntity=ConferenceUserImpl.class, optional=false)
    @JoinColumn(name="CREATOR", nullable=false)
    private final ConferenceUser creator;
    @Column(name="DESCRIPTION", length=1000)
    private String description;
    @Column(name="FILENAME", nullable=false, length=1000)
    private String filename;
    @Column(name="FILE_SIZE", nullable=false)
    private long size;
    @Column(name="LAST_UPDATED", nullable=false)
    @Type(type="dateTime")
    private DateTime lastUpdated;
    @ManyToMany(targetEntity=SessionImpl.class, fetch=FetchType.LAZY, mappedBy="multimedias")
    private final Set<SessionImpl> sessions = new HashSet(0);

    private MultimediaImpl() {
        this.bbMultimediaId = -1L;
        this.entityVersion = -1L;
        this.multimediaId = -1L;
        this.creator = null;
        this.description = null;
        this.size = -1L;
    }

    MultimediaImpl(long bbMultimediaId, ConferenceUser creator) {
        Validate.notNull((Object)creator, (String)"creator cannot be null");
        this.multimediaId = -1L;
        this.entityVersion = -1L;
        this.size = -1L;
        this.bbMultimediaId = bbMultimediaId;
        this.creator = creator;
    }

    @PreUpdate
    @PrePersist
    protected final void onUpdate() {
        this.lastUpdated = DateTime.now();
        if (this.description.length() == 0) {
            this.description = " ";
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(DateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public long getMultimediaId() {
        return this.multimediaId;
    }

    public long getBbMultimediaId() {
        return this.bbMultimediaId;
    }

    public ConferenceUser getCreator() {
        return this.creator;
    }

    public String toString() {
        return "MultimediaImpl [multimediaId=" + this.multimediaId + ", bbMultimediaId=" + this.bbMultimediaId + ", creator=" + this.creator + ", description=" + this.description + ", size=" + this.size + ", lastUpdated=" + this.lastUpdated + ", sessions=" + this.sessions + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bbMultimediaId ^ this.bbMultimediaId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultimediaImpl other = (MultimediaImpl)obj;
        return this.bbMultimediaId == other.bbMultimediaId;
    }
}

