/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.elluminate.sas.BlackboardServerConfigurationResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.portlet.blackboardvcportlet.dao.ServerConfigurationDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ServerConfigurationImpl;
import org.joda.time.DateTimeZone;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ServerConfigurationDaoImpl
extends BaseJpaDao
implements ServerConfigurationDao {
    private static final Pattern DATE_TZ_PATTERN = Pattern.compile(".+ \\(.+, [^ ]+ ([^:]+):([^\\)]+)\\)");

    @Transactional
    public ServerConfigurationImpl createOrUpdateConfiguration(BlackboardServerConfigurationResponse configurationResponse) {
        ServerConfigurationImpl serverConfiguration = this.getServerConfiguration();
        if (serverConfiguration == null) {
            serverConfiguration = new ServerConfigurationImpl();
        }
        serverConfiguration.onUpdate();
        if (serverConfiguration.getRandomCallbackUrl() == null) {
            serverConfiguration.setRandomCallbackUrl(RandomStringUtils.randomAlphanumeric((int)20));
        }
        serverConfiguration.setBoundaryTime(configurationResponse.getBoundaryTime());
        serverConfiguration.setMaxAvailableTalkers(configurationResponse.getMaxAvailableTalkers());
        serverConfiguration.setMaxAvailableCameras(configurationResponse.getMaxAvailableCameras());
        serverConfiguration.setRaiseHandOnEnter(configurationResponse.isRaiseHandOnEnter());
        serverConfiguration.setMayUseTelephony(configurationResponse.isMayUseTelephony());
        serverConfiguration.setMayUseSecureSignOn(configurationResponse.isMayUseSecureSignOn());
        serverConfiguration.setMustReserveSeats(configurationResponse.isMustReserveSeats());
        String timeZoneStr = configurationResponse.getTimeZone();
        Matcher tzMatcher = DATE_TZ_PATTERN.matcher(timeZoneStr);
        if (tzMatcher.matches()) {
            int hours = Integer.parseInt(tzMatcher.group(1));
            int minutes = Integer.parseInt(tzMatcher.group(2));
            DateTimeZone tz = DateTimeZone.forOffsetHoursMinutes((int)hours, (int)minutes);
            serverConfiguration.setTimezone(tz);
            this.logger.debug("Parsed timezone string '{}' to {}", (Object)timeZoneStr, (Object)tz);
        } else {
            DateTimeZone tz = DateTimeZone.getDefault();
            serverConfiguration.setTimezone(tz);
            this.logger.warn("Failed to parse timezone string '{}' defaulting to {}", (Object)timeZoneStr, (Object)tz);
        }
        this.getEntityManager().persist((Object)serverConfiguration);
        return serverConfiguration;
    }

    public ServerConfigurationImpl getServerConfiguration() {
        return (ServerConfigurationImpl)this.getEntityManager().find(ServerConfigurationImpl.class, (Object)"bsc");
    }

    @Transactional
    public void deleteServerConfiguration() {
        ServerConfigurationImpl serverConfiguration = this.getServerConfiguration();
        if (serverConfiguration != null) {
            this.getEntityManager().remove((Object)serverConfiguration);
        }
    }
}

