/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Version;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.jasig.portlet.blackboardvcportlet.data.ServerConfiguration;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Entity
@Table(name="VC2_SERVER_CONFIG")
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ServerConfigurationImpl
implements ServerConfiguration {
    public static final String CONFIG_ID = "bsc";
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="CONFIG_ID", nullable=false)
    private final String configId = "bsc";
    @Version
    @Column(name="ENTITY_VERSION", nullable=false)
    private final long entityVersion;
    @Column(name="BOUNDARY_TIME", nullable=false)
    private int boundaryTime;
    @Column(name="MAX_AVAILABLE_TALKERS", nullable=false)
    private int maxAvailableTalkers;
    @Column(name="MAX_AVAILABLE_CAMERAS", nullable=false)
    private int maxAvailableCameras;
    @Column(name="RAISE_HAND_ON_ENTER", nullable=false)
    private boolean raiseHandOnEnter;
    @Column(name="MAY_USE_TELEPHONY", nullable=false)
    private boolean mayUseTelephony;
    @Column(name="MAY_USE_SECURE_SIGN_ON", nullable=false)
    private boolean mayUseSecureSignOn;
    @Column(name="MUST_RESERVE_SEATS", nullable=false)
    private boolean mustReserveSeats;
    @Column(name="TIMEZONE", nullable=false)
    @Type(type="dateTimeZone")
    private DateTimeZone timezone;
    @Column(name="LAST_UPDATED", nullable=false)
    @Type(type="dateTime")
    private DateTime lastUpdated;
    @Column(name="CALLBACK_URL", nullable=false, length=80)
    private String randomCallbackUrl;

    ServerConfigurationImpl() {
        this.entityVersion = -1L;
    }

    protected final void onUpdate() {
        this.lastUpdated = DateTime.now();
    }

    public String getRandomCallbackUrl() {
        return this.randomCallbackUrl;
    }

    public void setRandomCallbackUrl(String value) {
        this.randomCallbackUrl = value;
    }

    public int getBoundaryTime() {
        return this.boundaryTime;
    }

    public void setBoundaryTime(int boundaryTime) {
        this.boundaryTime = boundaryTime;
    }

    public int getMaxAvailableTalkers() {
        return this.maxAvailableTalkers;
    }

    public void setMaxAvailableTalkers(int maxAvailableTalkers) {
        this.maxAvailableTalkers = maxAvailableTalkers;
    }

    public int getMaxAvailableCameras() {
        return this.maxAvailableCameras;
    }

    public void setMaxAvailableCameras(int maxAvailableCameras) {
        this.maxAvailableCameras = maxAvailableCameras;
    }

    public boolean isRaiseHandOnEnter() {
        return this.raiseHandOnEnter;
    }

    public void setRaiseHandOnEnter(boolean raiseHandOnEnter) {
        this.raiseHandOnEnter = raiseHandOnEnter;
    }

    public boolean isMayUseTelephony() {
        return this.mayUseTelephony;
    }

    public void setMayUseTelephony(boolean mayUseTelephony) {
        this.mayUseTelephony = mayUseTelephony;
    }

    public boolean isMayUseSecureSignOn() {
        return this.mayUseSecureSignOn;
    }

    public void setMayUseSecureSignOn(boolean mayUseSecureSignOn) {
        this.mayUseSecureSignOn = mayUseSecureSignOn;
    }

    public boolean isMustReserveSeats() {
        return this.mustReserveSeats;
    }

    public void setMustReserveSeats(boolean mustReserveSeats) {
        this.mustReserveSeats = mustReserveSeats;
    }

    public DateTimeZone getTimezone() {
        return this.timezone;
    }

    public void setTimezone(DateTimeZone timezone) {
        this.timezone = timezone;
    }

    public long getEntityVersion() {
        return this.entityVersion;
    }

    public DateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (CONFIG_ID == null ? 0 : CONFIG_ID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerConfigurationImpl other = (ServerConfigurationImpl)obj;
        if (CONFIG_ID == null) {
            other.getClass();
            if (CONFIG_ID != null) {
                return false;
            }
        } else {
            other.getClass();
            if (!CONFIG_ID.equals(CONFIG_ID)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "ServerConfigurationImpl [configId=bsc, entityVersion=" + this.entityVersion + ", boundaryTime=" + this.boundaryTime + ", maxAvailableTalkers=" + this.maxAvailableTalkers + ", maxAvailableCameras=" + this.maxAvailableCameras + ", raiseHandOnEnter=" + this.raiseHandOnEnter + ", mayUseTelephony=" + this.mayUseTelephony + ", mayUseSecureSignOn=" + this.mayUseSecureSignOn + ", mustReserveSeats=" + this.mustReserveSeats + ", timezone=" + this.timezone + ", lastUpdated=" + this.lastUpdated + "]";
    }
}

