/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.elluminate.sas.BlackboardRecordingLongResponse;
import com.google.common.base.Function;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Attribute;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.jpa.OpenEntityManager;
import org.jasig.portlet.blackboardvcportlet.dao.SessionRecordingDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.DaoUtils;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalSessionDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionRecordingImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionRecordingImpl_;
import org.jasig.portlet.blackboardvcportlet.data.SessionRecording;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class SessionRecordingDaoImpl
extends BaseJpaDao
implements SessionRecordingDao {
    private InternalSessionDao sessionDao;
    private CriteriaQuery<SessionRecordingImpl> findAllSessionRecordings;

    @Autowired
    public void setSessionDao(InternalSessionDao sessionDao) {
        this.sessionDao = sessionDao;
    }

    public void afterPropertiesSet() throws Exception {
        this.findAllSessionRecordings = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Set<SessionRecording> getAllRecordings() {
        TypedQuery query = this.createCachedQuery(this.findAllSessionRecordings);
        List sessionRecordings = query.getResultList();
        return new LinkedHashSet<SessionRecording>(sessionRecordings);
    }

    public SessionRecordingImpl getSessionRecording(long recordingId) {
        return (SessionRecordingImpl)this.getEntityManager().find(SessionRecordingImpl.class, (Object)recordingId);
    }

    @Transactional
    public SessionRecordingImpl createOrUpdateRecording(BlackboardRecordingLongResponse recordingLongResponse) {
        Long bbSessionId = recordingLongResponse.getSessionId();
        SessionImpl session = this.sessionDao.getSessionByBlackboardId(bbSessionId.longValue());
        if (session == null) {
            throw new IllegalArgumentException("No session with blackboard session id '" + bbSessionId + "' exists, cannot update recording");
        }
        long bbRecordingId = recordingLongResponse.getRecordingId();
        SessionRecordingImpl recording = this.getRecordingByBlackboardId(bbRecordingId);
        if (recording == null) {
            recording = new SessionRecordingImpl(bbRecordingId, session);
            this.logger.debug("Inserting new Recording for recording ID: " + bbRecordingId + " bbSessionId: " + session.getBbSessionId());
        }
        recording.setCreationDate(DaoUtils.toDateTime((long)recordingLongResponse.getCreationDate()));
        recording.setRecordingSize(recordingLongResponse.getRecordingSize());
        recording.setRecordingUrl(recordingLongResponse.getRecordingURL());
        recording.setRoomEnd(DaoUtils.toDateTime((long)recordingLongResponse.getRoomEndDate()));
        recording.setRoomStart(DaoUtils.toDateTime((long)recordingLongResponse.getRoomStartDate()));
        recording.setSecureSignOn(recordingLongResponse.isSecureSignOn());
        recording.setRoomName(recordingLongResponse.getRoomName());
        this.getEntityManager().persist((Object)recording);
        return recording;
    }

    @Transactional
    public void updateSessionRecording(SessionRecording recording) {
        this.getEntityManager().persist((Object)recording);
    }

    @OpenEntityManager
    public SessionRecordingImpl getRecordingByBlackboardId(long bbRecordingId) {
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(SessionRecordingImpl.class);
        query.using((Attribute)SessionRecordingImpl_.bbRecordingId, (Object)bbRecordingId);
        return (SessionRecordingImpl)query.load();
    }

    @Transactional
    public void deleteRecording(SessionRecording recording) {
        SessionRecordingImpl sessionRecording = this.getSessionRecording(recording.getRecordingId());
        SessionImpl session = sessionRecording.getSession();
        session.getSessionRecordings().remove(sessionRecording);
        EntityManager entityManager = this.getEntityManager();
        entityManager.remove((Object)sessionRecording);
        entityManager.persist((Object)session);
    }
}

