/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.impl;

import com.google.common.base.Function;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Attribute;
import org.apache.commons.lang.Validate;
import org.jasig.jpa.BaseJpaDao;
import org.jasig.jpa.OpenEntityManager;
import org.jasig.portlet.blackboardvcportlet.dao.UserSessionUrlDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.ConferenceUserImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.InternalSessionDao;
import org.jasig.portlet.blackboardvcportlet.dao.impl.SessionImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.UserSessionUrlImpl;
import org.jasig.portlet.blackboardvcportlet.dao.impl.UserSessionUrlImpl_;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.data.UserSessionUrl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class UserSessionUrlDaoImpl
extends BaseJpaDao
implements UserSessionUrlDao {
    private CriteriaQuery<UserSessionUrlImpl> findAllUserSessionUrl;
    private CriteriaQuery<UserSessionUrlImpl> findUserSessionUrls;
    private InternalConferenceUserDao blackboardUserDao;
    private InternalSessionDao sessionDao;

    @Autowired
    public void setSessionDao(InternalSessionDao dao) {
        this.sessionDao = dao;
    }

    @Autowired
    public void setBlackboardUserDao(InternalConferenceUserDao blackboardUserDao) {
        this.blackboardUserDao = blackboardUserDao;
    }

    public void afterPropertiesSet() throws Exception {
        this.findAllUserSessionUrl = this.createCriteriaQuery((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Set<UserSessionUrl> getAllUserSessionUrls() {
        TypedQuery query = this.createQuery(this.findAllUserSessionUrl);
        return new LinkedHashSet<UserSessionUrl>(query.getResultList());
    }

    @OpenEntityManager
    public UserSessionUrlImpl getUserSessionUrlsBySessionAndUser(Session session, ConferenceUser user) {
        SessionImpl sessionByBlackboardId = this.sessionDao.getSession(session.getSessionId());
        ConferenceUserImpl confUser = this.blackboardUserDao.getUser(user.getUserId());
        Validate.notNull((Object)sessionByBlackboardId);
        Validate.notNull((Object)confUser);
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(UserSessionUrlImpl.class);
        query.using((Attribute)UserSessionUrlImpl_.session, (Object)sessionByBlackboardId);
        query.using((Attribute)UserSessionUrlImpl_.user, (Object)confUser);
        return (UserSessionUrlImpl)query.load();
    }

    @Transactional
    public UserSessionUrlImpl createUserSessionUrl(Session session, ConferenceUser user, String url) {
        SessionImpl sessionFromDb = this.sessionDao.getSession(session.getSessionId());
        ConferenceUserImpl userFromDb = this.blackboardUserDao.getUser(user.getUserId());
        Validate.notNull((Object)sessionFromDb);
        Validate.notNull((Object)userFromDb);
        UserSessionUrlImpl urlObject = new UserSessionUrlImpl((Session)sessionFromDb, (ConferenceUser)userFromDb, url);
        this.getEntityManager().persist((Object)urlObject);
        return urlObject;
    }

    @Transactional
    public void deleteOldSessionUrls(Session session, ConferenceUser user) {
        EntityManager entityManager = this.getEntityManager();
        SessionImpl sessionFromDb = this.sessionDao.getSession(session.getSessionId());
        ConferenceUserImpl userFromDb = this.blackboardUserDao.getUser(user.getUserId());
        Validate.notNull((Object)sessionFromDb);
        Validate.notNull((Object)userFromDb);
        BaseJpaDao.NaturalIdQuery query = this.createNaturalIdQuery(UserSessionUrlImpl.class);
        query.using((Attribute)UserSessionUrlImpl_.session, (Object)sessionFromDb);
        query.using((Attribute)UserSessionUrlImpl_.user, (Object)userFromDb);
        UserSessionUrlImpl url = (UserSessionUrlImpl)query.load();
        entityManager.remove((Object)url);
        entityManager.flush();
    }
}

