/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.ws.impl;

import com.elluminate.sas.BlackboardListRepositoryMultimedia;
import com.elluminate.sas.BlackboardListSessionContent;
import com.elluminate.sas.BlackboardMultimediaResponse;
import com.elluminate.sas.BlackboardMultimediaResponseCollection;
import com.elluminate.sas.BlackboardRemoveRepositoryMultimedia;
import com.elluminate.sas.BlackboardRemoveSessionMultimedia;
import com.elluminate.sas.BlackboardSetSessionMultimedia;
import com.elluminate.sas.BlackboardUploadRepositoryContent;
import com.elluminate.sas.ObjectFactory;
import java.util.Collection;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import org.jasig.portlet.blackboardvcportlet.dao.ws.MultimediaWSDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.WSDaoUtils;
import org.jasig.portlet.blackboardvcportlet.service.util.SASWebServiceOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Service;

@Service
public class MultimediaWSDaoImpl
implements MultimediaWSDao {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private SASWebServiceOperations sasWebServiceOperations;

    @Autowired
    public void setSasWebServiceOperations(SASWebServiceOperations sasWebServiceOperations) {
        this.sasWebServiceOperations = sasWebServiceOperations;
    }

    public List<BlackboardMultimediaResponse> getRepositoryMultimedias(String creatorId, Long multimediaId, String description) {
        BlackboardListRepositoryMultimedia request = new ObjectFactory().createBlackboardListRepositoryMultimedia();
        if (creatorId == null && multimediaId == null && description == null) {
            throw new IllegalStateException("You must specify a creator, multimedia ID, or a description");
        }
        if (creatorId != null) {
            request.setCreatorId(creatorId);
        }
        if (multimediaId != null) {
            request.setMultimediaId(multimediaId);
        }
        if (description != null) {
            request.setDescription(description);
        }
        JAXBElement objSessionResponse = (JAXBElement)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListRespositoryMultimedia", (Object)request);
        return ((BlackboardMultimediaResponseCollection)objSessionResponse.getValue()).getMultimediaResponses();
    }

    public List<BlackboardMultimediaResponse> getSessionMultimedias(long bbSessionId) {
        BlackboardListSessionContent request = new ObjectFactory().createBlackboardListSessionContent();
        request.setSessionId(bbSessionId);
        JAXBElement createListSessionMultimedia = new ObjectFactory().createListSessionMultimedia(request);
        JAXBElement objSessionResponse = (JAXBElement)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListSessionMultimedia", (Object)createListSessionMultimedia);
        return ((BlackboardMultimediaResponseCollection)objSessionResponse.getValue()).getMultimediaResponses();
    }

    public BlackboardMultimediaResponse uploadRepositoryMultimedia(String creatorId, String filename, String description, DataHandler content) {
        BlackboardUploadRepositoryContent request = new ObjectFactory().createBlackboardUploadRepositoryContent();
        request.setCreatorId(creatorId);
        request.setDescription(description);
        request.setFilename(filename);
        request.setContent(content);
        JAXBElement realRequest = new ObjectFactory().createUploadRepositoryMultimedia(request);
        JAXBElement response = (JAXBElement)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/UploadRepositoryMultimedia", (Object)realRequest);
        return (BlackboardMultimediaResponse)DataAccessUtils.singleResult((Collection)((BlackboardMultimediaResponseCollection)response.getValue()).getMultimediaResponses());
    }

    public BlackboardMultimediaResponse createSessionMultimedia(long bbSessionId, String creatorId, String filename, String description, DataHandler content) {
        BlackboardMultimediaResponse multimediaMetaData = this.uploadRepositoryMultimedia(creatorId, filename, description, content);
        if (!this.linkSessionToMultimedia(bbSessionId, multimediaMetaData.getMultimediaId())) {
            this.logger.error("Error linking multimedia (" + multimediaMetaData.getMultimediaId() + ") to session (" + bbSessionId + "), however upload was successful.");
        }
        return multimediaMetaData;
    }

    public boolean linkSessionToMultimedia(long bbSessionId, long multimediaId) {
        BlackboardSetSessionMultimedia request = new ObjectFactory().createBlackboardSetSessionMultimedia();
        request.setMultimediaIds(Long.toString(multimediaId));
        request.setSessionId(bbSessionId);
        if (WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/SetSessionMultimedia", (Object)request))) {
            return true;
        }
        this.logger.error("Issue linking the multimedia id " + multimediaId + " with session " + bbSessionId);
        return false;
    }

    public boolean removeRepositoryMultimedia(long multimediaId) {
        BlackboardRemoveRepositoryMultimedia request = new ObjectFactory().createBlackboardRemoveRepositoryMultimedia();
        request.setMultimediaId(multimediaId);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/RemoveRepositoryMultimedia", (Object)request));
    }

    public boolean removeSessionMultimedia(long bbSessionId, long multimediaId) {
        BlackboardRemoveSessionMultimedia request = new ObjectFactory().createBlackboardRemoveSessionMultimedia();
        request.setSessionId(bbSessionId);
        request.setMultimediaId(multimediaId);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/RemoveSessionMultimedia", (Object)request));
    }
}

