/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.dao.ws.impl;

import com.elluminate.sas.BlackboardBuildSessionUrl;
import com.elluminate.sas.BlackboardClearSessionUserList;
import com.elluminate.sas.BlackboardListSession;
import com.elluminate.sas.BlackboardListSessionAttendance;
import com.elluminate.sas.BlackboardListSessionAttendanceResponseCollection;
import com.elluminate.sas.BlackboardRemoveSession;
import com.elluminate.sas.BlackboardSessionAttendanceResponse;
import com.elluminate.sas.BlackboardSessionResponse;
import com.elluminate.sas.BlackboardSessionResponseCollection;
import com.elluminate.sas.BlackboardSessionTelephony;
import com.elluminate.sas.BlackboardSessionTelephonyResponse;
import com.elluminate.sas.BlackboardSessionTelephonyResponseCollection;
import com.elluminate.sas.BlackboardSetSession;
import com.elluminate.sas.BlackboardSetSessionTelephony;
import com.elluminate.sas.BlackboardUpdateSession;
import com.elluminate.sas.BlackboardUrlResponse;
import com.elluminate.sas.ObjectFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import org.jasig.portlet.blackboardvcportlet.dao.ws.SessionWSDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.WSDaoUtils;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.RecordingMode;
import org.jasig.portlet.blackboardvcportlet.data.SessionTelephony;
import org.jasig.portlet.blackboardvcportlet.security.SecurityExpressionEvaluator;
import org.jasig.portlet.blackboardvcportlet.service.SessionForm;
import org.jasig.portlet.blackboardvcportlet.service.util.SASWebServiceOperations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Service;

@Service
public class SessionWSDaoImpl
implements SessionWSDao {
    private SASWebServiceOperations sasWebServiceOperations;
    private SecurityExpressionEvaluator securityExpressionEvaluator;

    @Autowired
    public void setSasWebServiceOperations(SASWebServiceOperations sasWebServiceOperations) {
        this.sasWebServiceOperations = sasWebServiceOperations;
    }

    @Autowired
    public void setSecurityExpressionEvaluator(SecurityExpressionEvaluator securityExpressionEvaluator) {
        this.securityExpressionEvaluator = securityExpressionEvaluator;
    }

    public BlackboardSessionResponse createSession(ConferenceUser user, SessionForm sessionForm) {
        BlackboardSetSession setSession = new BlackboardSetSession();
        setSession.setCreatorId(user.getUniqueId());
        setSession.setSessionName(sessionForm.getSessionName());
        setSession.setStartTime(sessionForm.getStartTime().getMillis());
        setSession.setEndTime(sessionForm.getEndTime().getMillis());
        setSession.setBoundaryTime(Integer.valueOf(sessionForm.getBoundaryTime()));
        setSession.setChairList(user.getUniqueId());
        if (this.securityExpressionEvaluator.authorize("hasRole('ROLE_FULL_ACCESS')")) {
            setSession.setMaxTalkers(Integer.valueOf(sessionForm.getMaxTalkers()));
            setSession.setMaxCameras(Integer.valueOf(sessionForm.getMaxCameras()));
            setSession.setMustBeSupervised(Boolean.valueOf(sessionForm.isMustBeSupervised()));
            setSession.setPermissionsOn(Boolean.valueOf(sessionForm.isPermissionsOn()));
            setSession.setRaiseHandOnEnter(Boolean.valueOf(sessionForm.isRaiseHandOnEnter()));
            RecordingMode recordingMode = sessionForm.getRecordingMode();
            if (recordingMode != null) {
                setSession.setRecordingModeType(Long.valueOf(recordingMode.getBlackboardRecordingMode()));
            }
            setSession.setHideParticipantNames(Boolean.valueOf(sessionForm.isHideParticipantNames()));
            setSession.setAllowInSessionInvites(Boolean.valueOf(sessionForm.isAllowInSessionInvites()));
        }
        Object objSessionResponse = this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/SetSession", (Object)setSession);
        JAXBElement jaxbSessionResponse = (JAXBElement)objSessionResponse;
        BlackboardSessionResponseCollection sessionResponses = (BlackboardSessionResponseCollection)jaxbSessionResponse.getValue();
        BlackboardSessionResponse sessionResponse = (BlackboardSessionResponse)DataAccessUtils.singleResult((Collection)sessionResponses.getSessionResponses());
        return sessionResponse;
    }

    public String buildSessionUrl(long sessionId, ConferenceUser user) {
        BlackboardBuildSessionUrl buildSessionUrlRequest = new BlackboardBuildSessionUrl();
        buildSessionUrlRequest.setSessionId(sessionId);
        buildSessionUrlRequest.setDisplayName(user.getDisplayName());
        buildSessionUrlRequest.setUserId(user.getBlackboardUniqueId());
        Object urlResponseObject = this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/BuildSessionUrl", (Object)buildSessionUrlRequest);
        JAXBElement jaxbResponse = (JAXBElement)urlResponseObject;
        return ((BlackboardUrlResponse)jaxbResponse.getValue()).getUrl();
    }

    public String buildGuestSessionUrl(long sessionId) {
        BlackboardBuildSessionUrl buildSessionUrlRequest = new BlackboardBuildSessionUrl();
        buildSessionUrlRequest.setSessionId(sessionId);
        buildSessionUrlRequest.setDisplayName("GUEST_PLACEHOLDER");
        Object urlResponseObject = this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/BuildSessionUrl", (Object)buildSessionUrlRequest);
        JAXBElement jaxbResponse = (JAXBElement)urlResponseObject;
        return ((BlackboardUrlResponse)jaxbResponse.getValue()).getUrl().replace("&username=GUEST_PLACEHOLDER", "");
    }

    public List<BlackboardSessionResponse> getSessions(String userId, String groupingId, Long sessionId, String creatorId, Long startTime, Long endTime, String sessionName) {
        BlackboardListSession request = new ObjectFactory().createBlackboardListSession();
        if (userId == null && groupingId == null && sessionId == null && creatorId == null && startTime == null && endTime == null && sessionName == null) {
            throw new IllegalStateException("You must specify at least 1 piece of criteria");
        }
        if (userId != null) {
            request.setUserId(userId);
        }
        if (groupingId != null) {
            request.setGroupingId(groupingId);
        }
        if (sessionId != null) {
            request.setSessionId(sessionId);
        }
        if (creatorId != null) {
            request.setCreatorId(creatorId);
        }
        if (startTime != null) {
            request.setStartTime(startTime);
        }
        if (endTime != null) {
            request.setEndTime(endTime);
        }
        if (sessionName != null) {
            request.setSessionName(sessionName);
        }
        Object obj = this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListSession", (Object)request);
        JAXBElement responseCollection = (JAXBElement)obj;
        return ((BlackboardSessionResponseCollection)responseCollection.getValue()).getSessionResponses();
    }

    public List<BlackboardSessionAttendanceResponse> getSessionAttendance(long sessionId, Object startTime) {
        BlackboardListSessionAttendance request = new ObjectFactory().createBlackboardListSessionAttendance();
        BlackboardListSessionAttendanceResponseCollection responseCollection = (BlackboardListSessionAttendanceResponseCollection)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListSessionAttendance", (Object)request);
        return responseCollection.getSessionAttendanceResponses();
    }

    public List<BlackboardSessionTelephonyResponse> getSessionTelephony(long sessionId) {
        BlackboardSessionTelephony request = new ObjectFactory().createBlackboardSessionTelephony();
        request.setSessionId(sessionId);
        BlackboardSessionTelephonyResponseCollection response = (BlackboardSessionTelephonyResponseCollection)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ListSessionTelephony", (Object)request);
        return response.getSessionTelephonyResponses();
    }

    public boolean removeSessionTelephony(long sessionId) {
        BlackboardSessionTelephony bst = new ObjectFactory().createBlackboardSessionTelephony();
        bst.setSessionId(sessionId);
        JAXBElement removeSessionTelephony = new ObjectFactory().createRemoveSessionTelephony(bst);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/RemoveSessionTelephony", (Object)removeSessionTelephony));
    }

    public BlackboardSessionTelephonyResponse createSessionTelephony(long sessionId, SessionTelephony telephony) {
        BlackboardSetSessionTelephony request = new ObjectFactory().createBlackboardSetSessionTelephony();
        request.setSessionId(sessionId);
        request.setChairPhone(telephony.getChairPhone());
        request.setChairPIN(telephony.getChairPIN());
        request.setIsPhone(telephony.isPhone());
        request.setNonChairPhone(telephony.getNonChairPhone());
        request.setNonChairPIN(telephony.getNonChairPIN());
        request.setSessionPIN(telephony.getSessionPIN());
        request.setSessionSIPPhone(telephony.getSessionSIPPhone());
        Object obj = this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/SetSessionTelephony", (Object)request);
        JAXBElement jaxbResponse = (JAXBElement)obj;
        return (BlackboardSessionTelephonyResponse)DataAccessUtils.singleResult((Collection)((BlackboardSessionTelephonyResponseCollection)jaxbResponse.getValue()).getSessionTelephonyResponses());
    }

    public BlackboardSessionResponse updateSession(long bbSessionId, SessionForm sessionForm) {
        BlackboardUpdateSession updateSession = new ObjectFactory().createBlackboardUpdateSession();
        updateSession.setSessionId(bbSessionId);
        updateSession.setSessionName(sessionForm.getSessionName());
        updateSession.setStartTime(Long.valueOf(sessionForm.getStartTime().getMillis()));
        updateSession.setEndTime(Long.valueOf(sessionForm.getEndTime().getMillis()));
        updateSession.setBoundaryTime(Integer.valueOf(sessionForm.getBoundaryTime()));
        if (this.securityExpressionEvaluator.authorize("hasRole('ROLE_FULL_ACCESS')")) {
            updateSession.setMaxTalkers(Integer.valueOf(sessionForm.getMaxTalkers()));
            updateSession.setMaxCameras(Integer.valueOf(sessionForm.getMaxCameras()));
            updateSession.setMustBeSupervised(Boolean.valueOf(sessionForm.isMustBeSupervised()));
            updateSession.setPermissionsOn(Boolean.valueOf(sessionForm.isPermissionsOn()));
            updateSession.setRaiseHandOnEnter(Boolean.valueOf(sessionForm.isRaiseHandOnEnter()));
            RecordingMode recordingMode = sessionForm.getRecordingMode();
            if (recordingMode != null) {
                updateSession.setRecordingModeType(Long.valueOf(recordingMode.getBlackboardRecordingMode()));
            }
            updateSession.setHideParticipantNames(Boolean.valueOf(sessionForm.isHideParticipantNames()));
            updateSession.setAllowInSessionInvites(Boolean.valueOf(sessionForm.isAllowInSessionInvites()));
        }
        Object objSessionResponse = this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/UpdateSession", (Object)updateSession);
        JAXBElement response = (JAXBElement)objSessionResponse;
        return (BlackboardSessionResponse)DataAccessUtils.singleResult((Collection)((BlackboardSessionResponseCollection)response.getValue()).getSessionResponses());
    }

    public BlackboardSessionResponse setSessionChairs(long bbSessionId, Set<ConferenceUser> sessionChairs) {
        BlackboardUpdateSession updateSession = new ObjectFactory().createBlackboardUpdateSession();
        updateSession.setSessionId(bbSessionId);
        String chairList = this.buildUidList(sessionChairs);
        updateSession.setChairList(chairList);
        Object objSessionResponse = this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/UpdateSession", (Object)updateSession);
        JAXBElement response = (JAXBElement)objSessionResponse;
        return (BlackboardSessionResponse)DataAccessUtils.singleResult((Collection)((BlackboardSessionResponseCollection)response.getValue()).getSessionResponses());
    }

    public BlackboardSessionResponse setSessionNonChairs(long bbSessionId, Set<ConferenceUser> sessionNonChairs) {
        BlackboardUpdateSession updateSession = new ObjectFactory().createBlackboardUpdateSession();
        updateSession.setSessionId(bbSessionId);
        String chairList = this.buildUidList(sessionNonChairs);
        updateSession.setNonChairList(chairList);
        Object objSessionResponse = this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/UpdateSession", (Object)updateSession);
        JAXBElement response = (JAXBElement)objSessionResponse;
        return (BlackboardSessionResponse)DataAccessUtils.singleResult((Collection)((BlackboardSessionResponseCollection)response.getValue()).getSessionResponses());
    }

    public boolean deleteSession(long sessionId) {
        BlackboardRemoveSession request = new ObjectFactory().createBlackboardRemoveSession();
        request.setSessionId(sessionId);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/RemoveSession", (Object)request));
    }

    public boolean clearSessionChairList(long sessionId) {
        return this.clearSessionUserList(Long.valueOf(sessionId), true);
    }

    public boolean clearSessionNonChairList(long sessionId) {
        return this.clearSessionUserList(Long.valueOf(sessionId), false);
    }

    private String buildUidList(Set<ConferenceUser> users) {
        StringBuilder uidBuilder = new StringBuilder();
        Iterator<ConferenceUser> userItr = users.iterator();
        while (userItr.hasNext()) {
            ConferenceUser user = userItr.next();
            uidBuilder.append(user.getBlackboardUniqueId());
            if (!userItr.hasNext()) continue;
            uidBuilder.append(',');
        }
        return uidBuilder.toString();
    }

    private boolean clearSessionUserList(Long sessionId, boolean isChairList) {
        BlackboardClearSessionUserList vo = new ObjectFactory().createBlackboardClearSessionUserList();
        vo.setSessionId(sessionId.longValue());
        JAXBElement request = isChairList ? new ObjectFactory().createClearSessionChairList(vo) : new ObjectFactory().createClearSessionNonChairList(vo);
        return WSDaoUtils.isSuccessful((Object)this.sasWebServiceOperations.marshalSendAndReceiveToSAS("http://sas.elluminate.com/ClearSession" + (isChairList ? "" : "Non") + "ChairList", (Object)request));
    }
}

