/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.admin;

import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;
import org.jasig.portlet.blackboardvcportlet.data.ServerConfiguration;
import org.jasig.portlet.blackboardvcportlet.data.ServerQuota;
import org.jasig.portlet.blackboardvcportlet.service.RecordingService;
import org.jasig.portlet.blackboardvcportlet.service.ServerConfigurationService;
import org.jasig.portlet.blackboardvcportlet.service.ServerQuotaService;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewAdminServerConfigController {
    private ServerConfigurationService serverConfigService;
    private ServerQuotaService serverQuotaService;
    private RecordingService recordingService;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public void setServerConfigurationService(ServerConfigurationService service) {
        this.serverConfigService = service;
    }

    @Autowired
    public void setServerQuota(ServerQuotaService service) {
        this.serverQuotaService = service;
    }

    @Autowired
    public void setRecordingService(RecordingService service) {
        this.recordingService = service;
    }

    @RenderMapping
    public String view(PortletRequest request, ModelMap model) {
        ServerConfiguration serverConfiguration = this.serverConfigService.getServerConfiguration();
        model.addAttribute("serverConfiguration", (Object)serverConfiguration);
        ServerQuota serverQuota = this.serverQuotaService.getServerQuota();
        model.addAttribute("serverQuota", (Object)serverQuota);
        return "admin_server_information";
    }

    @ResourceMapping(value="datafixRecording")
    public String datafixRecording(PortletRequest request, ResourceResponse response, ModelMap model) {
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        DateTime sd = DateTime.parse((String)startDate, (DateTimeFormatter)DateTimeFormat.forPattern((String)"MM-dd-YYYY"));
        DateTime ed = DateTime.parse((String)endDate, (DateTimeFormatter)DateTimeFormat.forPattern((String)"MM-dd-YYYY"));
        if (sd != null && ed != null) {
            int errd = this.recordingService.datafixRecordings(sd, ed);
            if (errd > 0) {
                this.logger.warn("During datafixRecording, " + errd + " failed to insert");
            }
        } else {
            response.setProperty("portlet.http-status-code", "400");
            response.setProperty("X-Status-Reason", "Validation failed");
        }
        return "json";
    }
}

