/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.validation.Valid;
import org.apache.commons.io.FilenameUtils;
import org.jasig.portlet.blackboardvcportlet.dao.SessionDao;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.MultimediaDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.ViewSessionListController;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.forms.DeleteMediaFilesForm;
import org.jasig.portlet.blackboardvcportlet.service.SessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class ManageMediaFilesController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SessionService sessionService;
    private SessionDao sessionDao;
    private ViewSessionListController viewController;
    private MessageSource messageSource;
    private String multimediaFileTypes;
    private Integer maxFileUploadSize;

    @Autowired
    public void setSessionDao(SessionDao sessionDao) {
        this.sessionDao = sessionDao;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Value(value="${multimediaFileTypes}")
    public void setMultimediaFileTypes(String multimediaFileTypes) {
        this.multimediaFileTypes = multimediaFileTypes;
    }

    @Value(value="${maxuploadsize}")
    public void setMaxFileUploadSize(Integer maxFileUploadSize) {
        this.maxFileUploadSize = maxFileUploadSize;
    }

    @Autowired
    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Autowired
    public void setViewController(ViewSessionListController viewController) {
        this.viewController = viewController;
    }

    @RenderMapping(params={"action=manageMediaFiles"})
    public String manageMultimedia(PortletRequest request, @RequestParam long sessionId, @RequestParam(required=false, value="multimediaUploadError") String multimediaUploadError, ModelMap model) {
        if (WindowState.NORMAL.equals((Object)request.getWindowState())) {
            return this.viewController.view(request, model, null, null);
        }
        model.addAttribute("multimediaFileTypes", (Object)this.multimediaFileTypes);
        if (multimediaUploadError != null && multimediaUploadError.length() > 0) {
            model.addAttribute("multimediaUploadError", (Object)multimediaUploadError);
        }
        Session session = this.sessionService.getSession(sessionId);
        model.addAttribute("session", (Object)session);
        return "manageMultimedia";
    }

    @ResourceMapping(value="getMediaFiles")
    public String getParticipants(@RequestParam long sessionId, ModelMap model) {
        Session session = this.sessionService.getSession(sessionId);
        Set sessionMultimedias = this.sessionDao.getSessionMultimedias(session);
        model.addAttribute("multimedias", (Object)ImmutableSortedSet.copyOf((Comparator)MultimediaDisplayComparator.INSTANCE, (Collection)sessionMultimedias));
        return "json";
    }

    @ActionMapping(value="uploadMediaFile")
    public void uploadMultimedia(ActionResponse response, Locale locale, @RequestParam long sessionId, @RequestParam MultipartFile multimediaUpload) throws PortletModeException {
        String fileExtension = FilenameUtils.getExtension((String)multimediaUpload.getOriginalFilename());
        if (multimediaUpload.getSize() < 1L) {
            response.setRenderParameter("multimediaUploadError", this.messageSource.getMessage("error.uploadfilenotselected", null, locale));
        } else if (multimediaUpload.getSize() > (long)this.maxFileUploadSize.intValue()) {
            response.setRenderParameter("multimediaUploadError", this.messageSource.getMessage("error.uploadfilesizetoobig", new Object[]{this.maxFileUploadSize}, locale));
        } else if (fileExtension.length() == 0 || !this.multimediaFileTypes.contains(fileExtension.toLowerCase())) {
            response.setRenderParameter("multimediaUploadError", this.messageSource.getMessage("error.uploadfileextensionswrong", null, locale));
        } else {
            this.sessionService.addMultimedia(sessionId, multimediaUpload);
        }
        response.setPortletMode(PortletMode.EDIT);
        response.setRenderParameter("sessionId", Long.toString(sessionId));
        response.setRenderParameter("action", "manageMediaFiles");
    }

    @ResourceMapping(value="deleteMediaFile")
    public String deleteMultimedia(ResourceResponse response, ModelMap model, @Valid DeleteMediaFilesForm deleteMediaFilesForm, BindingResult bindingResult) throws PortletModeException {
        if (bindingResult.hasErrors()) {
            response.setProperty("portlet.http-status-code", "400");
            response.setProperty("X-Status-Reason", "Validation failed");
            Map fieldErrors = this.getFieldErrors(bindingResult);
            model.put((Object)"fieldErrors", (Object)fieldErrors);
        } else {
            this.sessionService.deleteMultimedia(deleteMediaFilesForm.getSessionId(), deleteMediaFilesForm.getId());
        }
        return "json";
    }

    protected Map<String, String> getFieldErrors(BindingResult bindingResult) {
        LinkedHashMap<String, String> fieldErrors = new LinkedHashMap<String, String>();
        for (FieldError error : bindingResult.getFieldErrors()) {
            fieldErrors.put(error.getField(), error.getDefaultMessage());
        }
        return fieldErrors;
    }
}

