/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.ConferenceUserDisplayComparator;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.ViewSessionListController;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.forms.AddParticipantForm;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.forms.DeleteParticipantsForm;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.forms.UpdateParticipantForm;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceUserService;
import org.jasig.portlet.blackboardvcportlet.service.SessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class ManageParticipantsController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SessionService sessionService;
    private ViewSessionListController viewController;
    private ConferenceUserService conferenceUserService;

    @Autowired
    public void setConferenceUserService(ConferenceUserService conferenceUserService) {
        this.conferenceUserService = conferenceUserService;
    }

    @Autowired
    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @Autowired
    public void setViewController(ViewSessionListController viewController) {
        this.viewController = viewController;
    }

    @RenderMapping(params={"action=addParticipants"})
    public String viewParticipants(PortletRequest request, @RequestParam long sessionId, ModelMap model) {
        if (WindowState.NORMAL.equals((Object)request.getWindowState())) {
            return this.viewController.view(request, model, null, null);
        }
        Session session = this.sessionService.getSession(sessionId);
        model.addAttribute("session", (Object)session);
        return "viewParticipants";
    }

    @ResourceMapping(value="getParticipants")
    public String getParticipants(@RequestParam long sessionId, ModelMap model) {
        Session session = this.sessionService.getSession(sessionId);
        Set sessionChairs = this.sessionService.getSessionChairs(session);
        model.addAttribute("sessionChairs", (Object)ImmutableSortedSet.copyOf((Comparator)ConferenceUserDisplayComparator.INSTANCE, (Collection)sessionChairs));
        Set sessionNonChairs = this.sessionService.getSessionNonChairs(session);
        model.addAttribute("sessionNonChairs", (Object)ImmutableSortedSet.copyOf((Comparator)ConferenceUserDisplayComparator.INSTANCE, (Collection)sessionNonChairs));
        return "json";
    }

    @ResourceMapping(value="addParticipant")
    public String addParticipant(ResourceResponse response, ModelMap model, @Valid AddParticipantForm addParticipantForm, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            response.setProperty("portlet.http-status-code", "400");
            response.setProperty("X-Status-Reason", "Validation failed");
            Map fieldErrors = this.getFieldErrors(bindingResult);
            model.put((Object)"fieldErrors", (Object)fieldErrors);
        } else {
            String uniqueId = StringUtils.trimToNull((String)addParticipantForm.getUniqueId());
            String displayName = StringUtils.trimToNull((String)addParticipantForm.getName());
            String email = StringUtils.trimToNull((String)addParticipantForm.getEmail());
            ConferenceUser conferenceUser = this.conferenceUserService.getOrCreateConferenceUser(uniqueId, displayName, email);
            ConferenceUser participant = addParticipantForm.isModerator() ? this.sessionService.addSessionChair(addParticipantForm.getSessionId(), conferenceUser.getUserId()) : this.sessionService.addSessionNonChair(addParticipantForm.getSessionId(), conferenceUser.getUserId());
            model.put((Object)"participant", (Object)participant);
        }
        return "json";
    }

    @ResourceMapping(value="updateParticipant")
    public String updateParticipant(ResourceResponse response, ModelMap model, @Valid UpdateParticipantForm updateParticipantForm, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            response.setProperty("portlet.http-status-code", "400");
            response.setProperty("X-Status-Reason", "Validation failed");
            Map fieldErrors = this.getFieldErrors(bindingResult);
            model.put((Object)"fieldErrors", (Object)fieldErrors);
        } else {
            long sessionId = updateParticipantForm.getSessionId();
            long userId = updateParticipantForm.getId();
            ConferenceUser participant = updateParticipantForm.isModerator() ? this.sessionService.updateRole(sessionId, userId, ConferenceUser.Roles.CHAIR) : this.sessionService.updateRole(sessionId, userId, ConferenceUser.Roles.NONCHAIR);
            model.put((Object)"participant", (Object)participant);
        }
        return "json";
    }

    @ResourceMapping(value="deleteParticipant")
    public String deleteParticipants(ResourceResponse response, ModelMap model, @Valid DeleteParticipantsForm deleteParticipantForm, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            response.setProperty("portlet.http-status-code", "400");
            response.setProperty("X-Status-Reason", "Validation failed");
            Map fieldErrors = this.getFieldErrors(bindingResult);
            model.put((Object)"fieldErrors", (Object)fieldErrors);
        } else {
            this.sessionService.removeSessionChairs(deleteParticipantForm.getSessionId(), deleteParticipantForm.getId());
            this.sessionService.removeSessionNonChairs(deleteParticipantForm.getSessionId(), deleteParticipantForm.getId());
        }
        return "json";
    }

    @ResourceMapping(value="searchForParticipants")
    public String searchForParticipants(ModelMap model, @RequestParam(required=false) String name, @RequestParam(required=false) String email) {
        Set result = name != null ? this.conferenceUserService.searchForBasicUserByName(name) : (email != null ? this.conferenceUserService.searchForBasicUserByEmail(email) : Collections.emptySet());
        model.addAttribute("result", (Object)result);
        return "json";
    }

    protected Map<String, String> getFieldErrors(BindingResult bindingResult) {
        LinkedHashMap<String, String> fieldErrors = new LinkedHashMap<String, String>();
        for (FieldError error : bindingResult.getFieldErrors()) {
            fieldErrors.put(error.getField(), error.getDefaultMessage());
        }
        return fieldErrors;
    }
}

