/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.RenderRequest;
import javax.validation.Valid;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.data.SessionTelephony;
import org.jasig.portlet.blackboardvcportlet.mvc.sessionmngr.forms.TelephonyForm;
import org.jasig.portlet.blackboardvcportlet.service.SessionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.ws.soap.client.SoapFaultClientException;

@Controller
@RequestMapping(value={"EDIT"})
public class ManageTelephonyController {
    private SessionService sessionService;

    @Autowired
    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @RenderMapping(params={"action=configureTelephony"})
    public String manageTelephony(@RequestParam long sessionId, @RequestParam(required=false) String error, RenderRequest request, ModelMap model) {
        Session session = this.sessionService.getSession(sessionId);
        if (!model.containsAttribute("telephonyForm")) {
            SessionTelephony telephony = this.sessionService.getSessionTelephony(session);
            if (null == telephony) {
                telephony = new TelephonyForm(sessionId);
            }
            model.addAttribute("telephonyForm", (Object)telephony);
        }
        model.addAttribute("session", (Object)session);
        model.addAttribute("error", (Object)error);
        return "configureTelephony";
    }

    @ActionMapping(params={"action=saveTelephony"})
    public void saveTelephony(@Valid TelephonyForm telephonyForm, BindingResult bindingResult, ActionResponse response, ActionRequest request) throws PortletModeException {
        response.setRenderParameter("sessionId", Long.toString(telephonyForm.getSessionId()));
        if (bindingResult.hasErrors()) {
            response.setPortletMode(PortletMode.EDIT);
            response.setRenderParameter("action", "configureTelephony");
        } else {
            try {
                this.sessionService.createOrUpdateSessionTelephony(telephonyForm.getSessionId().longValue(), (SessionTelephony)telephonyForm);
                response.setPortletMode(PortletMode.VIEW);
                response.setRenderParameter("action", "viewSession");
            }
            catch (SoapFaultClientException ex) {
                if ("Telephony is not enabled".equalsIgnoreCase(ex.getMessage())) {
                    response.setRenderParameter("errorCode", "error.thirdPartyDisabled");
                } else {
                    response.setRenderParameter("error", ex.getMessage());
                }
                response.setPortletMode(PortletMode.EDIT);
                response.setRenderParameter("action", "configureTelephony");
            }
        }
    }

    @ActionMapping(params={"action=deleteTelephony"})
    public void removeTelephony(@RequestParam long sessionId, ActionResponse response) throws PortletModeException {
        this.sessionService.deleteSessionTelephony(sessionId);
        response.setRenderParameter("sessionId", Long.toString(sessionId));
        response.setPortletMode(PortletMode.VIEW);
        response.setRenderParameter("action", "viewSession");
    }
}

