/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.security;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jasig.portlet.blackboardvcportlet.dao.ConferenceUserDao;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.security.ConferenceSecurityUser;
import org.jasig.springframework.security.portlet.authentication.PortletAuthenticationDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class ConferenceUserPreAuthenticatedGrantedAuthoritiesUserDetailsService
extends PreAuthenticatedGrantedAuthoritiesUserDetailsService {
    private static final Pattern ATTRIBUTE_NAME_SEPERATOR = Pattern.compile(",");
    private ConferenceUserDao conferenceUserDao;
    private TransactionOperations transactionOperations;
    private List<String> uniqueIdAttributeName;
    private List<String> emailAttributeName;
    private List<String> displayNameAttributeName;

    @Autowired
    public void setConferenceUserDao(ConferenceUserDao conferenceUserDao) {
        this.conferenceUserDao = conferenceUserDao;
    }

    @Autowired
    public void setTransactionOperations(TransactionOperations transactionOperations) {
        this.transactionOperations = transactionOperations;
    }

    @Value(value="${emailAttributeName:mail}")
    public void setEmailAttributeName(String emailAttributeName) {
        this.emailAttributeName = ImmutableList.copyOf((Object[])ATTRIBUTE_NAME_SEPERATOR.split(emailAttributeName));
    }

    @Value(value="${displayNameAttributeName:displayName}")
    public void setDisplayNameAttributeName(String displayNameAttributeName) {
        this.displayNameAttributeName = ImmutableList.copyOf((Object[])ATTRIBUTE_NAME_SEPERATOR.split(displayNameAttributeName));
    }

    @Value(value="${uniqueIdAttributeName:uid}")
    public void setUniqueIdAttributeName(String uniqueIdAttributeName) {
        this.uniqueIdAttributeName = ImmutableList.copyOf((Object[])ATTRIBUTE_NAME_SEPERATOR.split(uniqueIdAttributeName));
    }

    protected UserDetails createuserDetails(Authentication token, Collection<? extends GrantedAuthority> authorities) {
        PortletAuthenticationDetails authenticationDetails = (PortletAuthenticationDetails)token.getDetails();
        ConferenceUser conferenceUser = this.setupConferenceUser(authenticationDetails);
        return new ConferenceSecurityUser(token.getName(), conferenceUser, authorities);
    }

    protected ConferenceUser setupConferenceUser(PortletAuthenticationDetails authenticationDetails) {
        String uniqueId = this.getAttribute(authenticationDetails, this.uniqueIdAttributeName, true);
        String mail = this.getAttribute(authenticationDetails, this.emailAttributeName, true);
        String displayName = this.getAttribute(authenticationDetails, this.displayNameAttributeName, false);
        return (ConferenceUser)this.transactionOperations.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getAttribute(PortletAuthenticationDetails authenticationDetails, List<String> attributeNames, boolean required) {
        Map userInfo = authenticationDetails.getUserInfo();
        for (String mailAttributeName : attributeNames) {
            String value = (String)userInfo.get(mailAttributeName);
            if (value == null) continue;
            return value;
        }
        if (required) {
            throw new IllegalStateException("Could not find required user attribute value in attributes: " + attributeNames);
        }
        return null;
    }

    static /* synthetic */ ConferenceUserDao access$000(ConferenceUserPreAuthenticatedGrantedAuthoritiesUserDetailsService x0) {
        return x0.conferenceUserDao;
    }
}

