/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.security;

import java.util.Map;
import org.jasig.portlet.blackboardvcportlet.security.SecurityExpressionEvaluator;
import org.jasig.portlet.blackboardvcportlet.security.SimpleSecurityExpressionHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityExpressionEvaluatorImpl
implements SecurityExpressionEvaluator,
ApplicationContextAware {
    private final SimpleSecurityExpressionHandler expressionHandler = new SimpleSecurityExpressionHandler();

    public final void setExpressionParser(ExpressionParser expressionParser) {
        this.expressionHandler.setExpressionParser(expressionParser);
    }

    public void setRoleHierarchy(RoleHierarchy roleHierarchy) {
        this.expressionHandler.setRoleHierarchy(roleHierarchy);
    }

    public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
        this.expressionHandler.setPermissionEvaluator(permissionEvaluator);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.expressionHandler.setApplicationContext(applicationContext);
    }

    public boolean authorize(String expression) {
        return this.authorize(expression, null);
    }

    public boolean authorize(String expression, Map<String, Object> variables) {
        Expression accessExpression = this.expressionHandler.getExpressionParser().parseExpression(expression);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        EvaluationContext evaluationContext = this.expressionHandler.createEvaluationContext(authentication, variables);
        return ExpressionUtils.evaluateAsBoolean((Expression)accessExpression, (EvaluationContext)evaluationContext);
    }
}

