/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Uid;
import org.apache.velocity.app.VelocityEngine;
import org.jasig.portlet.blackboardvcportlet.data.ConferenceUser;
import org.jasig.portlet.blackboardvcportlet.data.Session;
import org.jasig.portlet.blackboardvcportlet.service.MailTask;
import org.jasig.portlet.blackboardvcportlet.service.MailTemplateService;
import org.jasig.portlet.blackboardvcportlet.service.SessionService;
import org.jasig.portlet.blackboardvcportlet.service.impl.MailTemplateServiceImpl;
import org.jasig.portlet.blackboardvcportlet.service.util.MailMessages;
import org.jasig.portlet.blackboardvcportlet.service.util.MailSubstitutions;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Service(value="jasigMailTemplateService")
public class MailTemplateServiceImpl
implements BeanFactoryAware,
MailTemplateService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Queue<MailTask> theQueue = new ConcurrentLinkedQueue();
    private JavaMailSender mailSender;
    private BeanFactory beanFactory;
    private VelocityEngine velocityEngine;
    private SessionService sessionService;
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm z";
    private static final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"MM/dd/yyyy HH:mm z");
    private static final DateTimeZone timezone = DateTimeZone.forID((String)"America/Chicago");
    private String defaultFromAddress;
    @Value(value="${mail.sendMail}")
    private String sendMail;
    @Value(value="${mail.extParticipantMailMessage.subject}")
    private String externalParticipantSubject;
    @Value(value="${mail.intParticipantMailMessage.subject}")
    private String internalParticipantSubject;
    @Value(value="${mail.moderatorMailMessage.subject}")
    private String moderatorSubject;
    @Value(value="${mail.sessionDeletionMessage.subject}")
    private String sessionDeletionSubject;

    @Value(value="${mail.from}")
    public void setFrom(String from) {
        this.defaultFromAddress = from;
    }

    @Autowired
    public void setSessionService(SessionService service) {
        this.sessionService = service;
    }

    @Autowired
    public void setBeanFactory(BeanFactory bf) throws BeansException {
        this.beanFactory = bf;
    }

    @Autowired
    public void setJavaMailSender(JavaMailSender ms) {
        this.mailSender = ms;
    }

    @Autowired
    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    @Scheduled(fixedDelay=1000L)
    private void clearQueue() {
        MailTask cur = (MailTask)this.theQueue.poll();
        while (cur != null) {
            this.sendMail(cur);
            cur = (MailTask)this.theQueue.poll();
        }
    }

    public void sendMail(MailTask mt) {
        try {
            1 messagePreparator = new /* Unavailable Anonymous Inner Class!! */;
            this.mailSender.send((MimeMessagePreparator)messagePreparator);
        }
        catch (Exception e) {
            this.logger.error("Issue with sending email", (Throwable)e);
        }
    }

    public String buildEmailMessage(MailTask mailTask) {
        return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)this.velocityEngine, (String)mailTask.getTemplate().getClassPathToTemplate(), (String)"UTF-8", (Map)mailTask.getSubstitutions());
    }

    public void sendEmail(MailTask mailTask) {
        if ("true".equalsIgnoreCase(this.sendMail)) {
            this.theQueue.add(mailTask);
        }
    }

    public void buildAndSendSessionEmails(Session session, boolean isUpdate, boolean isFirstTime) {
        for (ConferenceUser moderator : this.sessionService.getSessionChairs(session)) {
            this.sendEmail(this.buildModeratorMailTask(moderator, session, isUpdate && !isFirstTime));
        }
        for (ConferenceUser user : this.sessionService.getSessionNonChairs(session)) {
            this.sendEmail(this.buildParticipantMailTask(user, session, isUpdate && !isFirstTime));
        }
    }

    public MailTask buildModeratorMailTask(ConferenceUser moderator, Session session, boolean isUpdate) {
        ArrayList<String> emailList = new ArrayList<String>();
        emailList.add(moderator.getEmail());
        String userSessionUrl = this.sessionService.getOrCreateSessionUrl(moderator, session);
        Map substitutions = this.createBaseSubstitutionMap(session);
        substitutions.put(MailSubstitutions.DISPLAY_NAME.toString(), moderator.getDisplayName());
        substitutions.put(MailSubstitutions.SESSION_USER_URL.toString(), userSessionUrl);
        substitutions.put(MailSubstitutions.SESSION_GUEST_URL.toString(), session.getGuestUrl());
        substitutions.put(MailSubstitutions.SESSION_UPDATE_TEXT.toString(), isUpdate ? "**Time update for existing session.**" : "");
        MailTask mt = new MailTask(emailList, substitutions, MailMessages.MODERATOR);
        mt.setMeetingInvite(this.buildIcsFile(session, moderator));
        mt.setSubject(this.moderatorSubject + ": " + session.getSessionName());
        return mt;
    }

    public MailTask buildSwitchRolesEmail(ConferenceUser user, Session session, ConferenceUser.Roles newRole) {
        MailTask mt;
        ArrayList<String> emailList = new ArrayList<String>();
        emailList.add(user.getEmail());
        String userSessionUrl = this.sessionService.getOrCreateSessionUrl(user, session);
        Map substitutions = this.createBaseSubstitutionMap(session);
        substitutions.put(MailSubstitutions.DISPLAY_NAME.toString(), user.getDisplayName());
        substitutions.put(MailSubstitutions.SESSION_USER_URL.toString(), userSessionUrl);
        substitutions.put(MailSubstitutions.SESSION_GUEST_URL.toString(), session.getGuestUrl());
        substitutions.put(MailSubstitutions.SESSION_CREATOR_EMAIL.toString(), session.getCreator().getEmail());
        substitutions.put(MailSubstitutions.SESSION_CREATOR_NAME.toString(), session.getCreator().getDisplayName());
        substitutions.put(MailSubstitutions.SESSION_UPDATE_TEXT.toString(), "*** Your role for this session has changed and the URL for the session has been updated ***");
        if (ConferenceUser.Roles.CHAIR.equals((Object)newRole)) {
            mt = new MailTask(emailList, substitutions, MailMessages.MODERATOR);
            mt.setSubject(this.moderatorSubject + ": " + session.getSessionName());
        } else {
            mt = new MailTask(emailList, substitutions, MailMessages.INTERNAL_PARTICIPANT);
            mt.setSubject(this.internalParticipantSubject + ": " + session.getSessionName());
        }
        mt.setMeetingInvite(this.buildIcsFile(session, user));
        return mt;
    }

    public MailTask buildParticipantMailTask(ConferenceUser participant, Session session, boolean isUpdate) {
        ArrayList<String> emailList = new ArrayList<String>();
        emailList.add(participant.getEmail());
        Map substitutions = this.createBaseSubstitutionMap(session);
        substitutions.put(MailSubstitutions.DISPLAY_NAME.toString(), participant.getDisplayName());
        substitutions.put(MailSubstitutions.SESSION_USER_URL.toString(), this.sessionService.getOrCreateSessionUrl(participant, session));
        substitutions.put(MailSubstitutions.SESSION_CREATOR_EMAIL.toString(), session.getCreator().getEmail());
        substitutions.put(MailSubstitutions.SESSION_CREATOR_NAME.toString(), session.getCreator().getDisplayName());
        substitutions.put(MailSubstitutions.SESSION_UPDATE_TEXT.toString(), isUpdate ? "**Time update for existing session.**" : "");
        MailTask mt = new MailTask(emailList, substitutions, MailMessages.EXTERNAL_PARTICIPANT);
        mt.setMeetingInvite(this.buildIcsFile(session, participant));
        mt.setSubject(this.internalParticipantSubject + ": " + session.getSessionName());
        return mt;
    }

    public void buildAndSendCancelationMeetingEmail(Session session) {
        ArrayList users = new ArrayList();
        users.addAll(this.sessionService.getSessionChairs(session));
        users.addAll(this.sessionService.getSessionNonChairs(session));
        for (ConferenceUser user : users) {
            this.sendEmail(this.buildCancellationNoticeMailTask(user, session));
        }
    }

    public MailTask buildCancellationNoticeMailTask(ConferenceUser user, Session session) {
        ArrayList<String> emailList = new ArrayList<String>();
        emailList.add(user.getEmail());
        Map substitutions = this.createBaseSubstitutionMap(session);
        substitutions.put(MailSubstitutions.DISPLAY_NAME.toString(), user.getDisplayName());
        substitutions.put(MailSubstitutions.SESSION_CREATOR_EMAIL.toString(), session.getCreator().getEmail());
        substitutions.put(MailSubstitutions.SESSION_CREATOR_NAME.toString(), session.getCreator().getDisplayName());
        MailTask mt = new MailTask(emailList, substitutions, MailMessages.SESSION_DELETION);
        mt.setMeetingInvite(this.buildIcsFile(session, user, true));
        mt.setSubject(this.sessionDeletionSubject + ": " + session.getSessionName());
        return mt;
    }

    private Map<String, String> createBaseSubstitutionMap(Session session) {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put(MailSubstitutions.SESSION_NAME.toString(), session.getSessionName());
        substitutions.put(MailSubstitutions.SESSION_TYPE.toString(), session.getAccessType().getName());
        substitutions.put(MailSubstitutions.SESSION_START_TIME.toString(), dateFormatter.print((ReadableInstant)session.getStartTime().withZone(timezone)));
        substitutions.put(MailSubstitutions.SESSION_END_TIME.toString(), dateFormatter.print((ReadableInstant)session.getEndTime().withZone(timezone)));
        substitutions.put(MailSubstitutions.SESSION_BOUNDARY_TIME.toString(), String.valueOf(session.getBoundaryTime()));
        return substitutions;
    }

    private Calendar buildIcsFile(Session session, ConferenceUser user) {
        return this.buildIcsFile(session, user, false);
    }

    private Calendar buildIcsFile(Session session, ConferenceUser user, boolean isCancellation) {
        String userSessionUrl = this.sessionService.getOrCreateSessionUrl(user, session);
        VEvent event = new VEvent((Date)new DateTime(session.getStartTime().toDate()), (Date)new DateTime(session.getEndTime().toDate()), session.getSessionName());
        Calendar cal = new Calendar();
        event.getProperties().add((Property)new Uid(String.valueOf(session.getSessionId()) + "-BlackboardCollaborate"));
        if (isCancellation) {
            event.getProperties().add((Property)Status.VEVENT_CANCELLED);
        } else {
            event.getProperties().add((Property)new Location(userSessionUrl));
            Description desc = new Description("Your join URL: " + userSessionUrl + "\n\nGuest join URL: " + session.getGuestUrl() + "\n\nCreator: " + session.getCreator().getDisplayName() + " (" + session.getCreator().getEmail() + ")");
            event.getProperties().add((Property)desc);
        }
        cal.getComponents().add((Component)event);
        return cal;
    }

    static /* synthetic */ String access$000(MailTemplateServiceImpl x0) {
        return x0.defaultFromAddress;
    }

    static /* synthetic */ String access$100(MailTemplateServiceImpl x0) {
        return x0.moderatorSubject;
    }

    static /* synthetic */ String access$200(MailTemplateServiceImpl x0) {
        return x0.internalParticipantSubject;
    }

    static /* synthetic */ String access$300(MailTemplateServiceImpl x0) {
        return x0.externalParticipantSubject;
    }

    static /* synthetic */ String access$400(MailTemplateServiceImpl x0) {
        return x0.sessionDeletionSubject;
    }
}

