/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.blackboardvcportlet.service.impl;

import org.jasig.portlet.blackboardvcportlet.dao.ServerConfigurationDao;
import org.jasig.portlet.blackboardvcportlet.dao.ws.GlobalSettingsWSDao;
import org.jasig.portlet.blackboardvcportlet.data.ServerConfiguration;
import org.jasig.portlet.blackboardvcportlet.service.ServerConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="serverConfigurationService")
public class ServerConfigurationServiceImpl
implements ServerConfigurationService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServerConfigurationDao serverConfigurationDao;
    private GlobalSettingsWSDao globalSettingsWSDao;

    @Autowired
    public void setServerConfigurationDao(ServerConfigurationDao serverConfigurationDao) {
        this.serverConfigurationDao = serverConfigurationDao;
    }

    @Autowired
    public void setGlobalSettingWSDao(GlobalSettingsWSDao value) {
        this.globalSettingsWSDao = value;
    }

    public ServerConfiguration getServerConfiguration() {
        ServerConfiguration serverConfiguration = this.serverConfigurationDao.getServerConfiguration();
        if (serverConfiguration == null) {
            serverConfiguration = this.refreshServerConfiguration();
        }
        return serverConfiguration;
    }

    @Scheduled(fixedRate=3600000L)
    public void scheduledRefreshServerConfiguration() {
        this.refreshServerConfiguration();
    }

    public ServerConfiguration refreshServerConfiguration() {
        ServerConfiguration currentServerConfiguration = this.serverConfigurationDao.getServerConfiguration();
        if (currentServerConfiguration != null && currentServerConfiguration.getLastUpdated().plusHours(1).isAfterNow()) {
            return currentServerConfiguration;
        }
        try {
            ServerConfiguration newServerConfiguration = this.serverConfigurationDao.createOrUpdateConfiguration(this.globalSettingsWSDao.getServerConfiguration());
            if (currentServerConfiguration == null || currentServerConfiguration.getRandomCallbackUrl() == null) {
                this.globalSettingsWSDao.setApiCallbackUrl(newServerConfiguration.getRandomCallbackUrl());
            }
            return newServerConfiguration;
        }
        catch (Exception ex) {
            this.logger.error("Failed to refresh ServerConfiguration", (Throwable)ex);
            return null;
        }
    }
}

