/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.athletics.dao;

import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.campuslife.athletics.dao.IAthleticsDao;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.AthleticsFeed;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.Sport;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class AthleticsDaoMockImpl
implements InitializingBean,
IAthleticsDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private AthleticsFeed feed;
    private Resource mockData;

    public void setMockData(Resource mockData) {
        this.mockData = mockData;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AthleticsFeed.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.feed = (AthleticsFeed)unmarshaller.unmarshal(this.mockData.getInputStream());
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read mock data", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to unmarshall mock data", (Throwable)e);
        }
    }

    @Override
    public AthleticsFeed getFeed() {
        return this.feed;
    }

    @Override
    public Sport getSport(String sport) {
        for (Sport s : this.feed.getSport()) {
            if (!sport.equals(s.getName())) continue;
            return s;
        }
        return null;
    }
}

