/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.athletics.dao;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.campuslife.athletics.dao.AthleticsScreenScrapingService;
import org.jasig.portlet.campuslife.athletics.dao.IAthleticsDao;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.AthleticsFeed;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.Sport;

public class ScreenScrapingAthleticsDaoImpl
implements IAthleticsDao {
    protected Log log = LogFactory.getLog(this.getClass());
    private AthleticsScreenScrapingService<Sport> screenScrapingService;
    private Map<String, String> sportUrls;

    public void setScreenScrapingService(AthleticsScreenScrapingService<Sport> screenScrapingService) {
        this.screenScrapingService = screenScrapingService;
    }

    public void setSportUrls(Map<String, String> urlMap) {
        this.sportUrls = urlMap;
    }

    public Map<String, String> getSportUrls() {
        return this.sportUrls;
    }

    @Override
    public AthleticsFeed getFeed() {
        AthleticsFeed feed = new AthleticsFeed();
        for (String sportKey : this.sportUrls.keySet()) {
            Sport sport = this.getSport(sportKey);
            if (sport == null) continue;
            feed.getSport().add(sport);
        }
        return feed;
    }

    @Override
    public Sport getSport(String sportKey) {
        String url = this.sportUrls.get(sportKey);
        if (url != null) {
            Sport sport = this.screenScrapingService.getItem(sportKey, url);
            sport.setName(sportKey);
            return sport;
        }
        return null;
    }
}

