/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.dining.dao;

import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.campuslife.dao.MockDataService;
import org.jasig.portlet.campuslife.dining.dao.IDiningMenuDao;
import org.jasig.portlet.campuslife.dining.model.menu.xml.DiningHall;
import org.jasig.portlet.campuslife.dining.model.menu.xml.Dish;
import org.jasig.portlet.campuslife.dining.model.menu.xml.FoodCategory;
import org.jasig.portlet.campuslife.dining.model.menu.xml.Meal;
import org.jasig.portlet.campuslife.dining.model.menu.xml.Menu;

public class MockDiningDaoImpl
extends MockDataService<Menu>
implements IDiningMenuDao {
    protected static final String PACKAGE_NAME = Menu.class.getPackage().getName();
    protected final Log log = LogFactory.getLog(this.getClass());

    @Override
    public List<DiningHall> getDiningHalls(PortletRequest request) {
        return ((Menu)this.getData()).getDiningHall();
    }

    @Override
    public DiningHall getDiningHall(String diningHall) {
        for (DiningHall hall : ((Menu)this.getData()).getDiningHall()) {
            if (!hall.getKey().equals(diningHall)) continue;
            return hall;
        }
        this.log.info((Object)("Unable to locate dining hall " + diningHall));
        return null;
    }

    @Override
    public Meal getMeal(String diningHall, String mealName) {
        DiningHall hall = this.getDiningHall(diningHall);
        if (hall != null) {
            for (Meal meal : hall.getMeal()) {
                if (!meal.getName().equals(mealName)) continue;
                return meal;
            }
            this.log.info((Object)("Unable to locate meal " + mealName + " at dining hall " + diningHall));
            return null;
        }
        return null;
    }

    @Override
    public FoodCategory getFoodCategory(String diningHall, String mealName, String categoryName) {
        Meal meal = this.getMeal(diningHall, mealName);
        if (meal != null) {
            for (FoodCategory category : meal.getFoodCategory()) {
                if (!category.getName().equals(categoryName)) continue;
                return category;
            }
            this.log.info((Object)("Unable to locate food category " + categoryName + " for dining hall " + diningHall + " at meal " + mealName));
            return null;
        }
        return null;
    }

    @Override
    public Dish getDish(String diningHall, String mealName, String dishName) {
        Meal meal = this.getMeal(diningHall, mealName);
        if (meal != null) {
            for (FoodCategory category : meal.getFoodCategory()) {
                for (Dish dish : category.getDish()) {
                    if (!dish.getName().equals(dishName)) continue;
                    return dish;
                }
            }
            this.log.info((Object)("Unable to locate dish " + dishName + " for dining hall " + diningHall + " at meal " + mealName));
            return null;
        }
        return null;
    }

    @Override
    public String getPackageName() {
        return PACKAGE_NAME;
    }
}

