/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.dining.dao;

import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.campuslife.dining.dao.DiningScreenScrapingService;
import org.jasig.portlet.campuslife.dining.dao.IDiningMenuDao;
import org.jasig.portlet.campuslife.dining.model.menu.xml.DiningHall;
import org.jasig.portlet.campuslife.dining.model.menu.xml.Dish;
import org.jasig.portlet.campuslife.dining.model.menu.xml.FoodCategory;
import org.jasig.portlet.campuslife.dining.model.menu.xml.Meal;

public class YaleDiningMenuDaoImpl
implements IDiningMenuDao {
    private String diningUrl = "http://www.yaledining.org/menu.cfm?mDH=";
    protected final Log log = LogFactory.getLog(this.getClass());
    private List<DiningHall> diningHalls;
    private DiningScreenScrapingService<DiningHall> diningHallService;

    public void setDiningHalls(List<DiningHall> diningHalls) {
        this.diningHalls = diningHalls;
    }

    @Override
    public List<DiningHall> getDiningHalls(PortletRequest request) {
        return this.diningHalls;
    }

    public void setDiningHallService(DiningScreenScrapingService<DiningHall> diningHallService) {
        this.diningHallService = diningHallService;
    }

    @Override
    public DiningHall getDiningHall(String diningHall) {
        return this.diningHallService.getItem(diningHall, this.diningUrl + diningHall);
    }

    @Override
    public Meal getMeal(String diningHall, String mealName) {
        DiningHall hall = this.getDiningHall(diningHall);
        for (Meal meal : hall.getMeal()) {
            if (!meal.getName().equals(mealName)) continue;
            return meal;
        }
        this.log.warn((Object)("Unable to find meal matching diningHall " + diningHall + " and meal name " + mealName));
        return null;
    }

    @Override
    public FoodCategory getFoodCategory(String diningHall, String mealName, String categoryName) {
        Meal meal = this.getMeal(diningHall, mealName);
        for (FoodCategory category : meal.getFoodCategory()) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        this.log.warn((Object)("Unable to find food category matching diningHall " + diningHall + " and meal name " + mealName + ", and food category " + categoryName));
        return null;
    }

    @Override
    public Dish getDish(String diningHall, String mealName, String dishName) {
        Meal meal = this.getMeal(diningHall, mealName);
        for (FoodCategory category : meal.getFoodCategory()) {
            for (Dish dish : category.getDish()) {
                if (!dishName.equals(dish.getName())) continue;
                return dish;
            }
        }
        this.log.warn((Object)("Unable to find dish matching diningHall " + diningHall + ", meal name " + mealName + ", and dish name " + dishName));
        return null;
    }
}

