/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.laundry.mvc.portlet;

import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.campuslife.laundry.dao.ILaundryDao;
import org.jasig.portlet.campuslife.laundry.model.laundry.xml.Laundromat;
import org.jasig.portlet.campuslife.mvc.IViewSelector;
import org.jasig.portlet.campuslife.service.IURLService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class LaundryController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IViewSelector viewSelector;
    private ILaundryDao laundryDao;
    private IURLService urlService;

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @Autowired(required=true)
    public void setLaundryDao(ILaundryDao laundryDao) {
        this.laundryDao = laundryDao;
    }

    @Autowired(required=true)
    public void setUrlService(IURLService urlService) {
        this.urlService = urlService;
    }

    @RenderMapping
    public ModelAndView showMainView(RenderRequest request, RenderResponse response) {
        boolean isMobile = this.viewSelector.isMobile((PortletRequest)request);
        String viewName = isMobile ? "main-jQM" : "main";
        ModelAndView mav = new ModelAndView("laundry/" + viewName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using view name " + viewName + " for main view"));
        }
        List<Laundromat> laundromats = this.laundryDao.getLaundromats((PortletRequest)request);
        mav.addObject("laundromats", laundromats);
        HashMap<String, String> locationUrls = new HashMap<String, String>();
        for (Laundromat laundromat : laundromats) {
            String url = this.urlService.getLocationUrl(laundromat.getLocationCode(), (PortletRequest)request);
            locationUrls.put(laundromat.getLocationCode(), url);
        }
        mav.addObject("locationUrls", locationUrls);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Rendering main view");
        }
        return mav;
    }

    @ActionMapping
    public void doAction() {
    }
}

