/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.campuslife.service.IURLService;
import org.springframework.beans.factory.annotation.Value;

public class UPortalURLServiceImpl
implements IURLService {
    protected final Log log = LogFactory.getLog(this.getClass());
    @Value(value="${portalContext}")
    private String portalContext;

    public void setPortalContext(String portalContext) {
        this.portalContext = portalContext;
    }

    @Override
    public String getLocationUrl(String identifier, PortletRequest request) {
        try {
            String encodedLocation = URLEncoder.encode(identifier, "UTF-8");
            return this.portalContext.concat("/s/location?id=").concat(encodedLocation);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)("Unable to encode location id " + identifier));
            return null;
        }
    }
}

