/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.athletics.dao;

import java.util.HashMap;
import java.util.List;
import org.jasig.portlet.campuslife.athletics.dao.IAthleticsDao;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.AthleticsFeed;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.Sport;

public class AthleticsDaoMergingImpl
implements IAthleticsDao {
    private List<IAthleticsDao> daos;

    public void setDaos(List<IAthleticsDao> daos) {
        this.daos = daos;
    }

    public AthleticsFeed getFeed() {
        AthleticsFeed feed = new AthleticsFeed();
        HashMap<String, Sport> sports = new HashMap<String, Sport>();
        for (IAthleticsDao dao : this.daos) {
            AthleticsFeed daoFeed = dao.getFeed();
            for (Sport daoSport : daoFeed.getSport()) {
                Sport sport = (Sport)sports.get(daoSport.getName());
                if (sport == null) {
                    sport = new Sport();
                    sport.setName(daoSport.getName());
                    sports.put(daoSport.getName(), sport);
                }
                sport.getNewsItem().addAll(daoSport.getNewsItem());
                sport.getCompetition().addAll(daoSport.getCompetition());
            }
        }
        feed.getSport().addAll(sports.values());
        return feed;
    }

    public Sport getSport(String sportKey) {
        Sport sport = new Sport();
        for (IAthleticsDao dao : this.daos) {
            Sport daoSport = dao.getSport(sportKey);
            if (daoSport == null) continue;
            sport.setName(sportKey);
            sport.getNewsItem().addAll(daoSport.getNewsItem());
            sport.getCompetition().addAll(daoSport.getCompetition());
        }
        return sport;
    }
}

