/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.athletics.dao.sample;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.Competition;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.Sport;
import org.jasig.portlet.campuslife.dao.IScreenScrapingPostProcessor;

public class UChicagoSportPostProcessorImpl
implements IScreenScrapingPostProcessor<Sport> {
    private static Pattern whitespace = Pattern.compile("\\s+");
    private static Pattern invalidNameChars = Pattern.compile("[^a-zA-Z\\(\\)\\- ]");
    private Map<String, String> sportUrls;

    public void setSportUrls(Map<String, String> urlMap) {
        this.sportUrls = urlMap;
    }

    public void postProcess(String key, Sport sport) {
        sport.setName(key);
        for (Competition competition : sport.getCompetition()) {
            String name = competition.getName().trim();
            Matcher invalidCharsMatcher = invalidNameChars.matcher(name);
            name = invalidCharsMatcher.replaceAll("");
            competition.setName(name);
            Matcher whitespaceMatcher = whitespace.matcher(name);
            name = whitespaceMatcher.replaceAll(" ");
            String url = competition.getUrl();
            if (url == null) continue;
            String sportUrl = (String)this.sportUrls.get(sport.getName());
            String fullUrl = sportUrl.substring(0, sportUrl.lastIndexOf("/")).concat("/").concat(url);
            competition.setUrl(fullUrl);
        }
    }
}

