/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.athletics.mvc.portlet;

import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.campuslife.athletics.dao.IAthleticsDao;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.AthleticsFeed;
import org.jasig.portlet.campuslife.athletics.model.feed.xml.Sport;
import org.jasig.portlet.campuslife.mvc.IViewSelector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class MainController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IViewSelector viewSelector;
    private IAthleticsDao athleticsDao;

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @Autowired(required=true)
    public void setAthleticsDao(IAthleticsDao athleticsDao) {
        this.athleticsDao = athleticsDao;
    }

    @RenderMapping
    public ModelAndView showMainView(RenderRequest request, RenderResponse response) {
        boolean isMobile = this.viewSelector.isMobile((PortletRequest)request);
        String viewName = isMobile ? "main-jQM" : "main";
        ModelAndView mav = new ModelAndView("athletics/" + viewName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using view name " + viewName + " for main view"));
        }
        AthleticsFeed feed = this.athleticsDao.getFeed();
        mav.addObject("sports", (Object)feed.getSport());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Rendering main view");
        }
        return mav;
    }

    @RenderMapping(params={"action=sportScores"})
    public ModelAndView showSportScores(String sport, RenderRequest request, RenderResponse response) {
        boolean isMobile = this.viewSelector.isMobile((PortletRequest)request);
        String viewName = isMobile ? "sportScores-jQM" : "sportScores";
        ModelAndView mav = new ModelAndView("athletics/" + viewName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using view name " + viewName + " for main view"));
        }
        Sport s = this.athleticsDao.getSport(sport);
        mav.addObject("sport", (Object)s);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Rendering main view");
        }
        return mav;
    }

    @RenderMapping(params={"action=sportNews"})
    public ModelAndView showSportNews(String sport, RenderRequest request, RenderResponse response) {
        boolean isMobile = this.viewSelector.isMobile((PortletRequest)request);
        String viewName = isMobile ? "sportNews-jQM" : "sportNews";
        ModelAndView mav = new ModelAndView("athletics/" + viewName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using view name " + viewName + " for main view"));
        }
        Sport s = this.athleticsDao.getSport(sport);
        mav.addObject("sport", (Object)s);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Rendering main view");
        }
        return mav;
    }

    @ActionMapping
    public void doAction() {
    }
}

