/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.dao;

import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public abstract class MockDataService<T>
implements InitializingBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Resource feed;
    private T data;

    @Autowired(required=true)
    public void setMockData(Resource feed) {
        this.feed = feed;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)this.getPackageName());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.data = unmarshaller.unmarshal(this.feed.getInputStream());
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read mock data", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to unmarshall mock data", (Throwable)e);
        }
    }

    public abstract String getPackageName();

    protected T getData() {
        return (T)this.data;
    }
}

