/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.dao;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jasig.portlet.campuslife.dao.IScreenScrapingPostProcessor;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.springframework.core.io.Resource;

public abstract class ScreenScrapingService<T> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Resource xslt;
    private Policy policy;
    private List<IScreenScrapingPostProcessor<T>> postProcessors;

    public void setXslt(Resource xslt) {
        this.xslt = xslt;
    }

    public void setPolicy(Resource config) throws PolicyException, IOException {
        this.policy = Policy.getInstance((File)config.getFile());
    }

    public abstract String getPackageName();

    public void setPostProcessors(List<IScreenScrapingPostProcessor<T>> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public T getItem(String key, String url) {
        try {
            this.log.debug((Object)url);
            String htmlContent = this.getHtmlContent(url);
            String cleanedContent = this.getCleanedHtmlContent(htmlContent);
            String xml = this.getXml(cleanedContent);
            this.log.debug((Object)xml);
            Object item = this.deserializeItem(xml);
            for (IScreenScrapingPostProcessor processor : this.postProcessors) {
                processor.postProcess(key, item);
            }
            return (T)item;
        }
        catch (ClientProtocolException e) {
            this.log.error((Object)"Failed to retrieve dining hall menu", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Failed to create identity transformer to serialize Node to String", e);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Failed to convert Node to String using Transformer", e);
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to retrieve dining hall menu", (Throwable)e);
        }
        catch (ScanException e) {
            this.log.error((Object)"Failed to parse dining hall menu", (Throwable)e);
        }
        catch (PolicyException e) {
            this.log.error((Object)"Failed to parse dining hall menu", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to parse dining hall menu", (Throwable)e);
        }
        return null;
    }

    protected String getHtmlContent(String url) throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        InputStream httpStream = response.getEntity().getContent();
        String content = IOUtils.toString((InputStream)httpStream);
        return content;
    }

    protected String getCleanedHtmlContent(String html) throws ScanException, PolicyException {
        AntiSamy as = new AntiSamy();
        CleanResults cr = as.scan(html, this.policy);
        String cleanedHtml = cr.getCleanHTML();
        String unescaped = cleanedHtml.replace("&", "&amp;");
        return unescaped;
    }

    protected String getXml(String cleanHtml) throws TransformerException, IOException {
        StreamSource xsltSource = new StreamSource(this.xslt.getInputStream());
        Transformer identityTransformer = transformerFactory.newTransformer(xsltSource);
        identityTransformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter outputWriter = new StringWriter();
        StreamResult outputTarget = new StreamResult(outputWriter);
        StreamSource xmlSource = new StreamSource(new StringReader(cleanHtml));
        identityTransformer.transform(xmlSource, outputTarget);
        String content = outputWriter.toString();
        return content;
    }

    protected T deserializeItem(String xml) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)this.getPackageName());
        Unmarshaller u = jc.createUnmarshaller();
        Object menu = u.unmarshal(IOUtils.toInputStream((String)xml));
        return (T)menu;
    }
}

