/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.campuslife.dining.mvc.portlet;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.campuslife.dining.dao.IDiningMenuDao;
import org.jasig.portlet.campuslife.dining.model.menu.xml.DiningHall;
import org.jasig.portlet.campuslife.dining.model.menu.xml.Dish;
import org.jasig.portlet.campuslife.dining.model.menu.xml.FoodCategory;
import org.jasig.portlet.campuslife.dining.model.menu.xml.Meal;
import org.jasig.portlet.campuslife.mvc.IViewSelector;
import org.jasig.portlet.campuslife.service.IURLService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class MainController {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private IDiningMenuDao menuDao;
    private IViewSelector viewSelector;
    private Map<String, String> dishCodeImages;
    private IURLService urlService;

    @Autowired(required=true)
    public void setDiningMenuDao(IDiningMenuDao diningMenuDao) {
        this.menuDao = diningMenuDao;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @Resource(name="dishCodeImages")
    public void setDishCodeImages(Map<String, String> images) {
        this.dishCodeImages = images;
    }

    @Autowired(required=true)
    public void setUrlService(IURLService urlService) {
        this.urlService = urlService;
    }

    @RenderMapping
    public ModelAndView showMainView(RenderRequest request) {
        boolean isMobile = this.viewSelector.isMobile((PortletRequest)request);
        String viewName = isMobile ? "main-jQM" : "main";
        ModelAndView mav = new ModelAndView("dining/".concat(viewName));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using view name " + viewName + " for main view"));
        }
        mav.addObject("diningHalls", (Object)this.menuDao.getDiningHalls((PortletRequest)request));
        return mav;
    }

    @RenderMapping(params={"action=diningHall"})
    public ModelAndView showDiningHallView(RenderRequest request, String diningHall) {
        boolean isMobile = this.viewSelector.isMobile((PortletRequest)request);
        String viewName = isMobile ? "diningHall-jQM" : "diningHall";
        ModelAndView mav = new ModelAndView("dining/".concat(viewName));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using view name " + viewName + " for dining hall view"));
        }
        DiningHall dh = this.menuDao.getDiningHall(diningHall);
        mav.addObject("diningHall", (Object)dh);
        String url = this.urlService.getLocationUrl(dh.getLocationCode(), (PortletRequest)request);
        mav.addObject("locationUrl", (Object)url);
        return mav;
    }

    @RenderMapping(params={"action=meal"})
    public ModelAndView showMealView(RenderRequest request, String diningHall, String mealName) {
        boolean isMobile = this.viewSelector.isMobile((PortletRequest)request);
        String viewName = isMobile ? "meal-jQM" : "meal";
        ModelAndView mav = new ModelAndView("dining/".concat(viewName));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using view name " + viewName + " for meal view"));
        }
        mav.addObject("dishCodeImages", (Object)this.dishCodeImages);
        mav.addObject("diningHallKey", (Object)diningHall);
        Meal meal = this.menuDao.getMeal(diningHall, mealName);
        ArrayList<FoodCategory> categories = new ArrayList<FoodCategory>();
        for (FoodCategory category : meal.getFoodCategory()) {
            categories.add(this.menuDao.getFoodCategory(diningHall, mealName, category.getName()));
        }
        DiningHall hall = this.menuDao.getDiningHall(diningHall);
        mav.addObject("diningHall", (Object)hall);
        mav.addObject("meal", (Object)meal);
        mav.addObject("categories", categories);
        return mav;
    }

    @RenderMapping(params={"action=dish"})
    public ModelAndView showDishView(RenderRequest request, String diningHall, String mealName, String dishName) {
        boolean isMobile = this.viewSelector.isMobile((PortletRequest)request);
        String viewName = isMobile ? "dish-jQM" : "dish";
        ModelAndView mav = new ModelAndView("dining/".concat(viewName));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using view name " + viewName + " for dish view"));
        }
        mav.addObject("dishCodeImages", (Object)this.dishCodeImages);
        mav.addObject("diningHallKey", (Object)diningHall);
        mav.addObject("mealName", (Object)mealName);
        Dish dish = this.menuDao.getDish(diningHall, mealName, dishName);
        mav.addObject("dish", (Object)dish);
        DiningHall hall = this.menuDao.getDiningHall(diningHall);
        mav.addObject("diningHall", (Object)hall);
        return mav;
    }

    @ActionMapping
    public void doAction() {
    }
}

