/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.mvc.portlet;

import java.util.HashMap;
import javax.portlet.PortletRequest;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.wrapper.CourseSummaryWrapper;
import org.jasig.portlet.courses.model.xml.Course;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class CoursesPortletController {
    private ICoursesDao coursesDao;

    @Autowired(required=true)
    public void setCoursesDao(ICoursesDao coursesDao) {
        this.coursesDao = coursesDao;
    }

    @RequestMapping
    public ModelAndView getCourseList(PortletRequest request) {
        HashMap<String, CourseSummaryWrapper> model = new HashMap<String, CourseSummaryWrapper>();
        model.put("courseList", this.coursesDao.getSummary(request));
        return new ModelAndView("courseList", model);
    }

    @RequestMapping(params={"action=showCourse"})
    public ModelAndView getCourseView(@RequestParam String courseCode, PortletRequest request) {
        HashMap<String, Course> model = new HashMap<String, Course>();
        CourseSummaryWrapper summary = this.coursesDao.getSummary(request);
        Course selectedCourse = null;
        for (Course course : summary.getCourses()) {
            if (!courseCode.equals(course.getCode())) continue;
            selectedCourse = course;
            break;
        }
        model.put("course", selectedCourse);
        return new ModelAndView("courseDetail", model);
    }
}

