/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao.sakai;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.sakai.xml.Announcement;
import org.jasig.portlet.courses.model.sakai.xml.Refs;
import org.jasig.portlet.courses.model.sakai.xml.Site;
import org.jasig.portlet.courses.model.wrapper.CourseSummaryWrapper;
import org.jasig.portlet.courses.model.wrapper.CourseWrapper;
import org.jasig.portlet.courses.model.xml.Course;
import org.jasig.portlet.courses.model.xml.Instructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class SakaiCoursesDaoImpl
implements ICoursesDao {
    private RestTemplate restTemplate;

    @Autowired(required=true)
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public CourseSummaryWrapper getSummary(PortletRequest request) {
        Refs refs = this.getSiteData(request);
        CourseSummaryWrapper courses = new CourseSummaryWrapper();
        for (Site site : refs.getRef0().getData().getSiteCollection().getSite()) {
            CourseWrapper course = new CourseWrapper();
            course.setCode(site.getId());
            course.setTitle(site.getEntityTitle());
            course.setUrl(site.getEntityURL());
            Instructor instructor = new Instructor();
            instructor.setFullName(site.getSiteOwner().getUserDisplayName());
            instructor.setIdentifier(site.getSiteOwner().getUserId());
            instructor.setAbbreviation(site.getSiteOwner().getUserId());
            course.getInstructors().add(instructor);
            courses.getCourses().add(course);
        }
        for (Announcement announcement : refs.getRef1().getData().getAnnouncementCollection().getAnnouncement()) {
            org.jasig.portlet.courses.model.xml.Announcement ann = new org.jasig.portlet.courses.model.xml.Announcement();
            ann.setTitle(announcement.getTitle());
            ann.setDescription(announcement.getBody());
            ann.setUrl(announcement.getEntityURL());
            for (Course course : courses.getCourses()) {
                if (!course.getTitle().equals(announcement.getSiteTitle())) continue;
                course.getAnnouncements().add(ann);
            }
        }
        return courses;
    }

    protected Refs getSiteData(PortletRequest request) {
        String sessionId = this.getAuthenticatedSession(request);
        Map<String, String> vars = Collections.singletonMap("sessionId", sessionId);
        return (Refs)this.restTemplate.getForObject("http://localhost:8180/direct/batch.xml?_refs=/direct/site.xml&_refs=/direct/announcement/user.xml&_sessionId={sessionId}", Refs.class, vars);
    }

    protected String getAuthenticatedSession(PortletRequest request) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        HashMap vars = new HashMap();
        vars.put("username", userInfo.get("user.login.id"));
        vars.put("password", userInfo.get("password"));
        return (String)this.restTemplate.postForObject("http://localhost:8180/direct/session.json?_username={username}&_password={password}", null, String.class, vars);
    }
}

