/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.model.xml;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import org.jasig.portlet.courses.model.xml.Term;

public abstract class TermListWrapper {
    public Term getTerm(String termCode) {
        for (Term term : this.getTerms()) {
            if (!termCode.equals(term.getCode())) continue;
            return term;
        }
        return null;
    }

    public Term getCurrentTerm() {
        Term rslt = null;
        int bestDist = Integer.MAX_VALUE;
        int currentYear = new GregorianCalendar().get(1);
        List<Term> terms = this.getTerms();
        for (Term term : terms) {
            if (term.getCurrent().booleanValue()) {
                return term;
            }
            BigInteger termYear = term.getYear();
            if (termYear == null) continue;
            if (rslt == null) {
                rslt = term;
                bestDist = Math.abs(termYear.intValue() - currentYear);
                continue;
            }
            int dist = Math.abs(termYear.intValue() - currentYear);
            if (dist >= bestDist) continue;
            rslt = term;
        }
        if (rslt == null && !terms.isEmpty()) {
            rslt = terms.get(0);
        }
        return rslt;
    }

    public abstract List<Term> getTerms();
}

