/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.model.xml;

import java.math.BigInteger;
import java.util.List;
import org.jasig.portlet.courses.model.xml.Term;
import org.joda.time.DateTime;

public abstract class TermListWrapper {
    public Term getTerm(String termCode) {
        for (Term term : this.getTerms()) {
            if (!termCode.equals(term.getCode())) continue;
            return term;
        }
        return null;
    }

    public Term getCurrentTerm() {
        Term bestDateMatch = null;
        int bestDist = Integer.MAX_VALUE;
        int currentYear = DateTime.now().year().get();
        for (Term term : this.getTerms()) {
            if (term.isCurrent()) {
                return term;
            }
            BigInteger termYear = term.getYear();
            if (termYear == null) continue;
            if (bestDateMatch == null) {
                bestDateMatch = term;
                bestDist = Math.abs(termYear.intValue() - currentYear);
                continue;
            }
            int dist = Math.abs(termYear.intValue() - currentYear);
            if (dist >= bestDist) continue;
            bestDateMatch = term;
        }
        return bestDateMatch;
    }

    public abstract List<Term> getTerms();
}

