/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.model.xml;

import java.io.IOException;
import java.util.List;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CourseMeetingWrapper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final DateTimeFormatter SHORT_TIME_FORMAT = DateTimeFormat.shortTime();

    public abstract LocalTime getStartTime();

    public abstract LocalTime getEndTime();

    public abstract List<String> getDayIds();

    public String getFormattedMeetingTime() {
        StringBuilder rslt = new StringBuilder();
        LocalTime startTime = this.getStartTime();
        LocalTime endTime = this.getEndTime();
        if (startTime != null) {
            try {
                SHORT_TIME_FORMAT.printTo((Appendable)rslt, (ReadablePartial)startTime);
                if (endTime != null) {
                    rslt.append(" - ");
                    SHORT_TIME_FORMAT.printTo((Appendable)rslt, (ReadablePartial)endTime);
                }
            }
            catch (IOException e) {
                this.logger.info("Failed to generate formatted string for course.startTime=" + startTime + " and course.endTime=" + endTime, (Throwable)e);
            }
        }
        return rslt.toString();
    }

    public String getFormattedMeetingDays() {
        StringBuilder rslt = new StringBuilder();
        List<String> days = this.getDayIds();
        if (days != null && days.size() != 0) {
            for (String day : days) {
                rslt.append(day).append(", ");
            }
            rslt.setLength(rslt.length() - 2);
        }
        return rslt.toString();
    }
}

