/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao.xml;

import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.lang.RandomStringUtils;

public final class SecureRequestCredentials
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PASSWORD_ALGORITHM = "PBEWithMD5AndDES";
    private static final int ITERATIONS = 20;
    private static final SecretKey SECRET_KEY;
    private final String username;
    private final SealedObject sealedPassword;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureRequestCredentials(String username, char[] password) {
        try {
            SealedObject sp;
            Cipher cipher = SecureRequestCredentials.getCipher(username, 1);
            try {
                sp = new SealedObject((Serializable)password, cipher);
            }
            catch (IllegalBlockSizeException e) {
                throw new Error("Failed to create SealedObject. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
            }
            catch (IOException e) {
                throw new Error("Failed to create SealedObject. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
            }
            this.username = username;
            this.sealedPassword = sp;
        }
        finally {
            Arrays.fill(password, ' ');
        }
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        Cipher cipher = SecureRequestCredentials.getCipher(this.username, 2);
        try {
            return (char[])this.sealedPassword.getObject(cipher);
        }
        catch (IllegalBlockSizeException e) {
            throw new Error("Failed to decrypt SealedObject. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
        catch (BadPaddingException e) {
            throw new Error("Failed to decrypt SealedObject. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
        catch (IOException e) {
            throw new Error("Failed to decrypt SealedObject. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
        catch (ClassNotFoundException e) {
            throw new Error("Failed to decrypt SealedObject. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
    }

    private static Cipher getCipher(String username, int opmode) {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(PASSWORD_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Failed to create Cipher for algorithm 'PBEWithMD5AndDES'. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
        catch (NoSuchPaddingException e) {
            throw new Error("Failed to create Cipher for algorithm 'PBEWithMD5AndDES'. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
        byte[] salt = SecureRequestCredentials.getSalt(username);
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
        try {
            cipher.init(opmode, (Key)SECRET_KEY, pbeParamSpec);
        }
        catch (InvalidKeyException e) {
            throw new Error("Failed to init Cipher for SecretKey '" + SECRET_KEY + "'. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Error("Failed to init Cipher for PBEParameterSpec '" + pbeParamSpec + "'. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
        return cipher;
    }

    private static byte[] getSalt(String username) {
        byte[] usernameBytes = username.getBytes();
        if (usernameBytes.length == 8) {
            return usernameBytes;
        }
        byte[] salt = new byte[8];
        System.arraycopy(usernameBytes, 0, salt, 0, Math.min(usernameBytes.length, salt.length));
        return salt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getPassword());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecureRequestCredentials other = (SecureRequestCredentials)obj;
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "SecureRequestCredentials [username=" + this.username + "]";
    }

    static {
        SecretKeyFactory secretKeyFactory;
        try {
            secretKeyFactory = SecretKeyFactory.getInstance(PASSWORD_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Failed to create SecretKeyFactory for algorithm 'PBEWithMD5AndDES'. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
        char[] keyPassPhrase = RandomStringUtils.randomAscii((int)256).toCharArray();
        PBEKeySpec pbeKeySpec = new PBEKeySpec(keyPassPhrase);
        try {
            SECRET_KEY = secretKeyFactory.generateSecret(pbeKeySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new Error("Failed to create SecretKey for PBEKeySpec '" + pbeKeySpec + "'. " + SecureRequestCredentials.class.getSimpleName() + " will not work", e);
        }
    }
}

