/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.degreeprogress.dao.mock;

import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.degreeprogress.dao.IDegreeProgressDao;
import org.jasig.portlet.degreeprogress.dao.WhatIfRequest;
import org.jasig.portlet.degreeprogress.model.StudentCourseRegistration;
import org.jasig.portlet.degreeprogress.model.xml.Course;
import org.jasig.portlet.degreeprogress.model.xml.CourseRequirement;
import org.jasig.portlet.degreeprogress.model.xml.DegreeProgressReport;
import org.jasig.portlet.degreeprogress.model.xml.DegreeRequirementSection;
import org.jasig.portlet.degreeprogress.model.xml.GeneralRequirementType;
import org.jasig.portlet.degreeprogress.model.xml.GpaRequirement;
import org.jasig.portlet.degreeprogress.model.xml.Grade;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class MockDegreeProgressDaoImpl
implements IDegreeProgressDao,
InitializingBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    private DegreeProgressReport report;
    private Resource mockData = new ClassPathResource("/mock-data/mock-progress-report.xml");

    public void setMockData(Resource mockData) {
        this.mockData = mockData;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DegreeProgressReport.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.report = (DegreeProgressReport)unmarshaller.unmarshal(this.mockData.getInputStream());
            for (DegreeRequirementSection section : this.report.getDegreeRequirementSections()) {
                for (JAXBElement requirement : section.getGeneralRequirements()) {
                    GeneralRequirementType req = (GeneralRequirementType)requirement.getValue();
                    if (!(req instanceof GpaRequirement)) continue;
                    section.setRequiredGpa(((GpaRequirement)req).getRequiredGpa());
                }
                for (CourseRequirement req : section.getCourseRequirements()) {
                    for (Course course : req.getCourses()) {
                        StudentCourseRegistration registration = new StudentCourseRegistration();
                        registration.setCredits(course.getCredits());
                        registration.setSource(course.getSource());
                        registration.setSemester(course.getSemester());
                        registration.setCourse(course);
                        Grade grade = new Grade();
                        grade.setCode(course.getGrade().getCode());
                        registration.setGrade(grade);
                        req.getRegistrations().add(registration);
                    }
                }
                this.report.addSection(section);
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read mock data", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to unmarshall mock data", (Throwable)e);
        }
    }

    @Override
    public DegreeProgressReport getProgressReport(PortletRequest request) {
        return this.report;
    }

    @Override
    public Boolean getWebEnabled(PortletRequest request) {
        return Boolean.TRUE;
    }

    @Override
    public WhatIfRequest createWhatIfRequest(PortletRequest request) {
        return null;
    }

    @Override
    public DegreeProgressReport getWhatIfReport(WhatIfRequest whatIfRequest) {
        return null;
    }
}

