/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao.xml;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.jasig.portlet.courses.model.xml.personal.TermsAndCourses;
import org.jasig.portlet.courses.util.IParameterEvaluator;
import org.jasig.portlet.courses.util.TermCodeParameterEvaluator;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpClientCoursesDaoImpl
implements ICoursesDao {
    public static final String PROPERTY_KEY_TERMCODE = "#TERMCODE#";
    private final Log log = LogFactory.getLog(this.getClass());
    private String termsUrlFormat = null;
    private String coursesUrlFormat = null;
    private Map<String, IParameterEvaluator> urlParams = new HashMap<String, IParameterEvaluator>();
    private IParameterEvaluator usernameEvaluator;
    private IParameterEvaluator passwordEvaluator;
    private RestTemplate restTemplate;

    public void setTermsUrlFormat(String urlFormat) {
        this.termsUrlFormat = urlFormat;
    }

    public void setCoursesUrlFormat(String urlFormat) {
        this.coursesUrlFormat = urlFormat;
    }

    public void setUrlParams(Map<String, IParameterEvaluator> params) {
        this.urlParams = params;
    }

    public void setUsernameEvaluator(IParameterEvaluator usernameEvaluator) {
        this.usernameEvaluator = usernameEvaluator;
    }

    public void setPasswordEvaluator(IParameterEvaluator passwordEvaluator) {
        this.passwordEvaluator = passwordEvaluator;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public TermList getTermList(PortletRequest request) {
        Map<String, String> params = this.createParameters(request, this.urlParams);
        return this.getTermsAndCourses(request, this.termsUrlFormat, params).getTermList();
    }

    @Override
    public CoursesByTerm getCoursesByTerm(PortletRequest request, String termCode) {
        this.setTermCodeRequestAttribute(request, termCode);
        Map<String, String> params = this.createParameters(request, this.urlParams);
        return this.getTermsAndCourses(request, this.coursesUrlFormat, params).getCoursesByTerm(termCode);
    }

    protected TermsAndCourses getTermsAndCourses(PortletRequest request, String uriTemplate, Map<String, String> params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking uri '" + uriTemplate + "' with the following parameters:  " + params.toString()));
        }
        HttpEntity<?> requestEntity = this.getRequestEntity(request);
        ResponseEntity response = this.restTemplate.exchange(uriTemplate, HttpMethod.GET, requestEntity, TermsAndCourses.class, params);
        return (TermsAndCourses)response.getBody();
    }

    protected HttpEntity<?> getRequestEntity(PortletRequest request) {
        String username = this.usernameEvaluator.evaluate(request);
        String password = this.passwordEvaluator.evaluate(request);
        if (this.log.isDebugEnabled()) {
            boolean hasPassword = password != null;
            this.log.debug((Object)("Preparing HttpEntity for user '" + username + "' (password provided = " + hasPassword + ")"));
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        String authString = username.concat(":").concat(password);
        String encodedAuthString = new Base64().encodeToString(authString.getBytes());
        requestHeaders.set("Authorization", "Basic ".concat(encodedAuthString));
        HttpEntity rslt = new HttpEntity((MultiValueMap)requestHeaders);
        return rslt;
    }

    protected void setTermCodeRequestAttribute(PortletRequest request, String termCode) {
        for (IParameterEvaluator evaluator : this.urlParams.values()) {
            if (!(evaluator instanceof TermCodeParameterEvaluator)) continue;
            request.setAttribute(((TermCodeParameterEvaluator)evaluator).getAttributeKey(), (Object)termCode);
            return;
        }
    }

    protected Map<String, String> createParameters(PortletRequest request, Map<String, IParameterEvaluator> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : params.keySet()) {
            result.put(key, params.get(key).evaluate(request));
        }
        return result;
    }
}

