/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao.xml;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.courses.dao.ICacheableCoursesDao;
import org.jasig.portlet.courses.dao.xml.SecureRequestCredentials;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.jasig.portlet.courses.model.xml.personal.TermsAndCourses;
import org.jasig.portlet.courses.util.IParameterEvaluator;
import org.jasig.portlet.courses.util.TermCodeParameterEvaluator;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class HttpClientCoursesDaoImpl
implements ICacheableCoursesDao<CoursesCacheKey, CoursesCacheKey> {
    public static final String PROPERTY_KEY_TERMCODE = "#TERMCODE#";
    private final Log log = LogFactory.getLog(this.getClass());
    private String termsUrlFormat = null;
    private String coursesUrlFormat = null;
    private Map<String, IParameterEvaluator> urlParamEvaluators = new HashMap<String, IParameterEvaluator>();
    private IParameterEvaluator usernameEvaluator;
    private IParameterEvaluator passwordEvaluator;
    private RestOperations restTemplate;

    public void setTermsUrlFormat(String urlFormat) {
        this.termsUrlFormat = urlFormat;
    }

    public void setCoursesUrlFormat(String urlFormat) {
        this.coursesUrlFormat = urlFormat;
    }

    public void setUrlParams(Map<String, IParameterEvaluator> params) {
        this.urlParamEvaluators = params;
    }

    public void setUsernameEvaluator(IParameterEvaluator usernameEvaluator) {
        this.usernameEvaluator = usernameEvaluator;
    }

    public void setPasswordEvaluator(IParameterEvaluator passwordEvaluator) {
        this.passwordEvaluator = passwordEvaluator;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public CoursesCacheKey getTermListKey(PortletRequest request) {
        String username = this.usernameEvaluator.evaluate(request);
        String password = this.passwordEvaluator.evaluate(request);
        Map<String, String> params = this.createParameters(request, this.urlParamEvaluators);
        return new CoursesCacheKey(username, password.toCharArray(), (Map)params);
    }

    @Override
    public TermList getTermList(CoursesCacheKey key) {
        TermsAndCourses termsAndCourses = this.getTermsAndCourses(key, this.termsUrlFormat);
        return termsAndCourses.getTermList();
    }

    @Override
    public CoursesCacheKey getCoursesByTermKey(PortletRequest request, String termCode, TermList termList) {
        String username = this.usernameEvaluator.evaluate(request);
        String password = this.passwordEvaluator.evaluate(request);
        Map<String, String> params = this.createParameters(request, this.urlParamEvaluators);
        return new CoursesCacheKey(username, password.toCharArray(), params, termCode);
    }

    @Override
    public CoursesByTerm getCoursesByTerm(CoursesCacheKey key) {
        TermsAndCourses termsAndCourses = this.getTermsAndCourses(key, this.coursesUrlFormat);
        return termsAndCourses.getCoursesByTerm(key.getTermCode());
    }

    protected TermsAndCourses getTermsAndCourses(CoursesCacheKey key, String url) {
        Map params = key.getParams();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking uri '" + url + "' with the following parameters:  " + params.toString()));
        }
        HttpEntity<?> requestEntity = this.getRequestEntity(key);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, TermsAndCourses.class, params);
        TermsAndCourses termsAndCourses = (TermsAndCourses)response.getBody();
        return termsAndCourses;
    }

    protected HttpEntity<?> getRequestEntity(CoursesCacheKey credentials) {
        String username = credentials.getUsername();
        char[] password = credentials.getPassword();
        if (this.log.isDebugEnabled()) {
            boolean hasPassword = password != null;
            this.log.debug((Object)("Preparing HttpEntity for user '" + username + "' (password provided = " + hasPassword + ")"));
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        String authString = username.concat(":").concat(new String(password));
        String encodedAuthString = new Base64().encodeToString(authString.getBytes());
        requestHeaders.set("Authorization", "Basic ".concat(encodedAuthString));
        HttpEntity rslt = new HttpEntity((MultiValueMap)requestHeaders);
        return rslt;
    }

    protected void setTermCodeRequestAttribute(PortletRequest request, String termCode) {
        for (IParameterEvaluator evaluator : this.urlParamEvaluators.values()) {
            if (!(evaluator instanceof TermCodeParameterEvaluator)) continue;
            request.setAttribute(((TermCodeParameterEvaluator)evaluator).getAttributeKey(), (Object)termCode);
            return;
        }
    }

    protected Map<String, String> createParameters(PortletRequest request, Map<String, IParameterEvaluator> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : params.keySet()) {
            result.put(key, params.get(key).evaluate(request));
        }
        return result;
    }

    public static final class CoursesCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final SecureRequestCredentials credentials;
        private final Map<String, String> params;
        private final String termCode;

        private CoursesCacheKey(String username, char[] password, Map<String, String> params) {
            this(username, password, params, null);
        }

        private CoursesCacheKey(String username, char[] password, Map<String, String> params, String termCode) {
            this.credentials = new SecureRequestCredentials(username, password);
            this.params = params;
            this.termCode = termCode;
        }

        private String getUsername() {
            return this.credentials.getUsername();
        }

        private char[] getPassword() {
            return this.credentials.getPassword();
        }

        private Map<String, String> getParams() {
            return this.params;
        }

        public String getTermCode() {
            return this.termCode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.credentials == null ? 0 : this.credentials.hashCode());
            result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoursesCacheKey other = (CoursesCacheKey)obj;
            if (this.credentials == null ? other.credentials != null : !this.credentials.equals(other.credentials)) {
                return false;
            }
            return !(this.params == null ? other.params != null : !this.params.equals(other.params));
        }

        public String toString() {
            return "CoursesCacheKey [credentials=" + this.credentials + ", params=" + this.params + "]";
        }
    }
}

