/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao;

import java.io.Serializable;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.jasig.portlet.courses.dao.ICacheableCoursesDao;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Required;

public final class CachingCoursesDao
implements ICoursesDao,
BeanNameAware {
    private ICacheableCoursesDao<Serializable, Serializable> coursesDao;
    private SelfPopulatingCache termListCache;
    private SelfPopulatingCache coursesByTermCache;
    private boolean scopeKeysToDao = true;
    private String beanName;

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setEnclosedCoursesDao(ICacheableCoursesDao<Serializable, Serializable> coursesDao) {
        this.coursesDao = coursesDao;
    }

    public void setScopeKeysToDao(boolean scopeKeysToDao) {
        this.scopeKeysToDao = scopeKeysToDao;
    }

    @Required
    public void setTermListCache(Ehcache termListCache) {
        this.termListCache = new SelfPopulatingCache(termListCache, new CacheEntryFactory(){

            public Object createEntry(Object key) throws Exception {
                CacheKey scopedKey = (CacheKey)key;
                return CachingCoursesDao.this.coursesDao.getTermList(scopedKey.key);
            }
        });
    }

    @Required
    public void setCoursesByTermCache(Ehcache coursesByTermCache) {
        this.coursesByTermCache = new SelfPopulatingCache(coursesByTermCache, new CacheEntryFactory(){

            public Object createEntry(Object key) throws Exception {
                CacheKey scopedKey = (CacheKey)key;
                return CachingCoursesDao.this.coursesDao.getCoursesByTerm(scopedKey.key);
            }
        });
    }

    @Override
    public TermList getTermList(PortletRequest request) {
        Serializable termListKey = this.coursesDao.getTermListKey(request);
        CacheKey scopedKey = this.getScopedKey(termListKey);
        Element element = this.termListCache.get((Serializable)scopedKey);
        if (element == null) {
            return null;
        }
        return (TermList)element.getObjectValue();
    }

    @Override
    public CoursesByTerm getCoursesByTerm(PortletRequest request, String termCode) {
        TermList termList = this.getTermList(request);
        Serializable coursesByTermKey = this.coursesDao.getCoursesByTermKey(request, termCode, termList);
        CacheKey scopedKey = this.getScopedKey(coursesByTermKey);
        Element element = this.coursesByTermCache.get((Serializable)scopedKey);
        if (element == null) {
            return null;
        }
        return (CoursesByTerm)element.getObjectValue();
    }

    protected CacheKey getScopedKey(Serializable key) {
        if (this.scopeKeysToDao) {
            return new CacheKey(this.beanName, key);
        }
        return new CacheKey(key);
    }

    private static final class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String scope;
        private final Serializable key;

        public CacheKey(Serializable key) {
            this.scope = null;
            this.key = key;
        }

        public CacheKey(String scope, Serializable key) {
            this.scope = scope;
            this.key = key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
        }

        public String toString() {
            return "ScopedCacheKey [scope=" + this.scope + ", key=" + this.key + "]";
        }
    }
}

