/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao;

import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.xml.Term;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.Course;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MergingCoursesDaoImpl
implements ICoursesDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private List<ICoursesDao> courseDaos;

    @Autowired
    @Qualifier(value="courseDaos")
    public void setCourseDaos(List<ICoursesDao> courseDaos) {
        this.courseDaos = courseDaos;
    }

    @Override
    public TermList getTermList(PortletRequest request) {
        TermList summary = null;
        for (ICoursesDao dao : this.courseDaos) {
            try {
                TermList daoSummary = dao.getTermList(request);
                if (summary == null) {
                    summary = daoSummary;
                    continue;
                }
                this.mergeTermSummaries(summary, daoSummary);
            }
            catch (Exception e) {
                this.log.error((Object)"Exception reading course dao", (Throwable)e);
            }
        }
        return summary;
    }

    @Override
    public CoursesByTerm getCoursesByTerm(PortletRequest request, String termCode) {
        CoursesByTerm summary = null;
        for (ICoursesDao dao : this.courseDaos) {
            try {
                CoursesByTerm daoSummary = dao.getCoursesByTerm(request, termCode);
                if (summary == null) {
                    summary = daoSummary;
                    continue;
                }
                this.mergeCourseSummaries(summary, daoSummary);
            }
            catch (Exception e) {
                this.log.error((Object)"Exception reading course dao", (Throwable)e);
            }
        }
        return summary;
    }

    protected void mergeTermSummaries(TermList original, TermList additional) {
        List originalTerms = original.getTerms();
        for (Term t : additional.getTerms()) {
            Term originalTerm = original.getTerm(t.getCode());
            if (originalTerm != null) continue;
            originalTerms.add(t);
        }
    }

    protected void mergeCourseSummaries(CoursesByTerm original, CoursesByTerm additional) {
        if (additional.getCredits() != null) {
            original.setCredits(additional.getCredits());
        }
        if (additional.getGpa() != null) {
            original.setGpa(additional.getGpa());
        }
        for (Course c : additional.getCourses()) {
            Course course = original.getCourse(c.getCode());
            if (course != null) {
                this.mergeCourse(course, c);
                continue;
            }
            original.getCourses().add(c);
        }
    }

    protected void mergeCourse(Course original, Course additional) {
        if (additional.getCredits() != null) {
            original.setCredits(additional.getCredits());
        }
        if (additional.getGrade() != null) {
            original.setGrade(additional.getGrade());
        }
        if (additional.getCourseMeetings() != null) {
            original.getCourseMeetings().addAll(additional.getCourseMeetings());
        }
        if (additional.getCourseUpdates() != null) {
            original.getCourseUpdates().addAll(additional.getCourseUpdates());
        }
        if (additional.getInstructors() != null) {
            original.getInstructors().addAll(additional.getInstructors());
        }
        if (additional.getSchool() != null) {
            original.setSchool(additional.getSchool());
        }
        if (additional.getTitle() != null) {
            original.setTitle(additional.getTitle());
        }
    }
}

