/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.courses.dao.ICoursesSectionDao;
import org.jasig.portlet.courses.model.xml.CourseMeeting;
import org.jasig.portlet.courses.model.xml.CourseSection;
import org.jasig.portlet.courses.model.xml.TermList;
import org.jasig.portlet.courses.model.xml.personal.Course;
import org.jasig.portlet.courses.model.xml.personal.CoursesByTerm;
import org.jasig.portlet.courses.model.xml.personal.TermsAndCourses;
import org.jasig.portlet.courses.util.CourseCompareByDeptAndCatalog;
import org.springframework.core.io.Resource;

public class MockCoursesSectionDao
implements ICoursesSectionDao {
    protected final Log log = LogFactory.getLog(this.getClass());
    private TermsAndCourses summary;
    private Resource mockData;

    public void setMockData(Resource mockData) {
        this.mockData = mockData;
    }

    @Override
    public TermList getTermList(PortletRequest request) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TermsAndCourses.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.summary = (TermsAndCourses)unmarshaller.unmarshal(this.mockData.getInputStream());
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read mock data for TermList", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to unmarshall mock data for TermList", (Throwable)e);
        }
        return this.summary.getTermList();
    }

    @Override
    public CoursesByTerm getCoursesByTerm(PortletRequest request, String termCode, TermList termList) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TermsAndCourses.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.summary = (TermsAndCourses)unmarshaller.unmarshal(this.mockData.getInputStream());
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read mock data for CourseByTerm", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to unmarshall mock data for CourseByTerm", (Throwable)e);
        }
        CoursesByTerm courseByTerm = this.summary.getCoursesByTerm(termCode);
        List courses = courseByTerm.getCourses();
        Collections.sort(courses, new CourseCompareByDeptAndCatalog());
        return courseByTerm;
    }

    @Override
    public Course getCoursesBySection(PortletRequest request, String termCode, String catalogNbr, String subjectCode, String courseId, String classNbr, TermList termList) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TermsAndCourses.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.summary = (TermsAndCourses)unmarshaller.unmarshal(this.mockData.getInputStream());
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read mock data for CourseByTerm", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to unmarshall mock data for CourseByTerm", (Throwable)e);
        }
        CoursesByTerm courseByTerm = this.summary.getCoursesByTerm(termCode);
        for (Course course : courseByTerm.getCourses()) {
            if (!course.getId().equals(courseId)) continue;
            this.log.debug((Object)"Course Found !!!!");
            return course;
        }
        return null;
    }

    @Override
    public List<Course> getFinalExams(PortletRequest request, String termCode, TermList termList) {
        List<Object> courseList = new ArrayList<Course>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TermsAndCourses.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.summary = (TermsAndCourses)unmarshaller.unmarshal(this.mockData.getInputStream());
            CoursesByTerm courseByTerm = this.summary.getCoursesByTerm(termCode);
            courseList = courseByTerm.getCourses();
            for (Course course : courseList) {
                for (CourseSection courseSection : course.getCourseSections()) {
                    ArrayList<CourseMeeting> courseMeetings = new ArrayList<CourseMeeting>();
                    for (CourseMeeting courseMeeting : courseSection.getCourseMeetings()) {
                        if (!courseMeeting.getType().equals("EXAM")) continue;
                        courseMeetings.add(courseMeeting);
                    }
                    courseSection.getCourseMeetings().clear();
                    courseSection.getCourseMeetings().addAll(courseMeetings);
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read mock data for CourseByTerm", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to unmarshall mock data for CourseByTerm", (Throwable)e);
        }
        return courseList;
    }

    @Override
    public List<Course> getClassSchedule(PortletRequest request, String termCode, TermList termList) {
        List<Object> courseList = new ArrayList<Course>();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TermsAndCourses.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            this.summary = (TermsAndCourses)unmarshaller.unmarshal(this.mockData.getInputStream());
            CoursesByTerm courseByTerm = this.summary.getCoursesByTerm(termCode);
            courseList = courseByTerm.getCourses();
            for (Course course : courseList) {
                for (CourseSection courseSection : course.getCourseSections()) {
                    ArrayList<CourseMeeting> courseMeetings = new ArrayList<CourseMeeting>();
                    for (CourseMeeting courseMeeting : courseSection.getCourseMeetings()) {
                        if (!courseMeeting.getType().equals("CLASS")) continue;
                        courseMeetings.add(courseMeeting);
                    }
                    courseSection.getCourseMeetings().clear();
                    courseSection.getCourseMeetings().addAll(courseMeetings);
                }
            }
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to read mock data for CourseByTerm", (Throwable)e);
        }
        catch (JAXBException e) {
            this.log.error((Object)"Failed to unmarshall mock data for CourseByTerm", (Throwable)e);
        }
        return courseList;
    }
}

