/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.degreeprogress.dao;

import java.io.Serializable;
import javax.portlet.PortletRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.degreeprogress.dao.IDegreeProgressDao;
import org.jasig.portlet.degreeprogress.dao.WhatIfRequest;
import org.jasig.portlet.degreeprogress.model.xml.DegreeProgressReport;

public class CachingDegreeProgressDao
implements IDegreeProgressDao {
    private final Log log = LogFactory.getLog(this.getClass());
    private IDegreeProgressDao enclosedDegreeProgressDao;
    private Cache progressReportCache;

    public void setEnclosedDegreeProgressDao(IDegreeProgressDao enclosedDegreeProgressDao) {
        this.enclosedDegreeProgressDao = enclosedDegreeProgressDao;
    }

    public void setProgressReportCache(Cache progressReportCache) {
        this.progressReportCache = progressReportCache;
    }

    @Override
    public DegreeProgressReport getProgressReport(PortletRequest request) {
        DegreeProgressReport rslt = null;
        String cacheKey = this.getDegreeProgressCacheKey(request);
        Element m = this.progressReportCache.get((Serializable)((Object)cacheKey));
        if (m != null) {
            rslt = (DegreeProgressReport)m.getValue();
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Fetching new DegreeProgressReport from enclosedDegreeProgressDao for user '" + request.getRemoteUser() + "'"));
            }
            rslt = this.enclosedDegreeProgressDao.getProgressReport(request);
            m = new Element((Serializable)((Object)cacheKey), (Serializable)rslt);
            this.progressReportCache.put(m);
        }
        return rslt;
    }

    @Override
    public Boolean getWebEnabled(PortletRequest request) {
        return null;
    }

    @Override
    public WhatIfRequest createWhatIfRequest(PortletRequest request) {
        return null;
    }

    @Override
    public DegreeProgressReport getWhatIfReport(WhatIfRequest whatIfRequest) {
        return null;
    }

    private String getDegreeProgressCacheKey(PortletRequest request) {
        return CachingDegreeProgressDao.class.getName() + "." + request.getRemoteUser();
    }
}

