/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.degreeprogress.dao.xml;

import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.xml.bind.JAXBElement;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.courses.util.IParameterEvaluator;
import org.jasig.portlet.degreeprogress.dao.IDegreeProgressDao;
import org.jasig.portlet.degreeprogress.dao.WhatIfRequest;
import org.jasig.portlet.degreeprogress.model.StudentCourseRegistration;
import org.jasig.portlet.degreeprogress.model.xml.Course;
import org.jasig.portlet.degreeprogress.model.xml.CourseRequirement;
import org.jasig.portlet.degreeprogress.model.xml.DegreeProgressReport;
import org.jasig.portlet.degreeprogress.model.xml.DegreeRequirementSection;
import org.jasig.portlet.degreeprogress.model.xml.GeneralRequirementType;
import org.jasig.portlet.degreeprogress.model.xml.GpaRequirement;
import org.jasig.portlet.degreeprogress.model.xml.Grade;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpDegreeProgressDaoImpl
implements IDegreeProgressDao {
    private final Log log = LogFactory.getLog(this.getClass());
    private IParameterEvaluator usernameEvaluator;
    private IParameterEvaluator passwordEvaluator;
    private Map<String, IParameterEvaluator> urlParams = new HashMap<String, IParameterEvaluator>();
    private RestTemplate restTemplate;
    private String degreeProgressUrlFormat = null;

    public void setUsernameEvaluator(IParameterEvaluator usernameEvaluator) {
        this.usernameEvaluator = usernameEvaluator;
    }

    public void setUrlParams(Map<String, IParameterEvaluator> params) {
        this.urlParams = params;
    }

    public void setPasswordEvaluator(IParameterEvaluator passwordEvaluator) {
        this.passwordEvaluator = passwordEvaluator;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setDegreeProgressUrlFormat(String urlFormat) {
        this.degreeProgressUrlFormat = urlFormat;
    }

    @Override
    public DegreeProgressReport getProgressReport(PortletRequest request) {
        Map<String, String> params = this.createParameters(request, this.urlParams);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Invoking uri '" + this.degreeProgressUrlFormat + "' with the following parameters:  " + params.toString()));
        }
        HttpEntity<?> requestEntity = this.getRequestEntity(request);
        ResponseEntity response = this.restTemplate.exchange(this.degreeProgressUrlFormat, HttpMethod.GET, requestEntity, DegreeProgressReport.class, params);
        DegreeProgressReport report = (DegreeProgressReport)response.getBody();
        for (DegreeRequirementSection section : report.getDegreeRequirementSections()) {
            for (JAXBElement requirement : section.getGeneralRequirements()) {
                GeneralRequirementType req = (GeneralRequirementType)requirement.getValue();
                if (!(req instanceof GpaRequirement)) continue;
                section.setRequiredGpa(((GpaRequirement)req).getRequiredGpa());
            }
            for (CourseRequirement req : section.getCourseRequirements()) {
                for (Course course : req.getCourses()) {
                    StudentCourseRegistration registration = new StudentCourseRegistration();
                    registration.setCredits(course.getCredits());
                    registration.setSource(course.getSource());
                    registration.setSemester(course.getSemester());
                    registration.setCourse(course);
                    Grade grade = new Grade();
                    grade.setCode(course.getGrade().getCode());
                    registration.setGrade(grade);
                    req.getRegistrations().add(registration);
                }
            }
            report.addSection(section);
        }
        return report;
    }

    @Override
    public Boolean getWebEnabled(PortletRequest request) {
        return Boolean.TRUE;
    }

    @Override
    public WhatIfRequest createWhatIfRequest(PortletRequest request) {
        return null;
    }

    @Override
    public DegreeProgressReport getWhatIfReport(WhatIfRequest whatIfRequest) {
        return null;
    }

    protected HttpEntity<?> getRequestEntity(PortletRequest request) {
        String username = this.usernameEvaluator.evaluate(request);
        String password = this.passwordEvaluator.evaluate(request);
        if (this.log.isDebugEnabled()) {
            boolean hasPassword = password != null;
            this.log.debug((Object)("Preparing HttpEntity for user '" + username + "' (password provided = " + hasPassword + ")"));
        }
        HttpHeaders requestHeaders = new HttpHeaders();
        String authString = username.concat(":").concat(password);
        String encodedAuthString = new Base64().encodeToString(authString.getBytes());
        requestHeaders.set("Authorization", "Basic ".concat(encodedAuthString));
        HttpEntity rslt = new HttpEntity((MultiValueMap)requestHeaders);
        return rslt;
    }

    protected Map<String, String> createParameters(PortletRequest request, Map<String, IParameterEvaluator> params) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : params.keySet()) {
            result.put(key, params.get(key).evaluate(request));
        }
        return result;
    }
}

