/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.dao.xml;

import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.commons.codec.binary.Base64;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.wrapper.CourseSummaryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpClientCoursesDaoImpl
implements ICoursesDao {
    private String urlFormat = "http://localhost:8180/jasig-courses-integration/course-summary";
    private String usernameKey = "user.login.id";
    private String passwordKey = "password";
    private RestTemplate restTemplate;

    public void setUrlFormat(String urlFormat) {
        this.urlFormat = urlFormat;
    }

    public void setUsernameKey(String usernameKey) {
        this.usernameKey = usernameKey;
    }

    public void setPasswordKey(String passwordKey) {
        this.passwordKey = passwordKey;
    }

    @Autowired(required=true)
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public CourseSummaryWrapper getSummary(PortletRequest request) {
        HttpEntity requestEntity = this.getRequestEntity(request);
        ResponseEntity response = this.restTemplate.exchange(this.urlFormat, HttpMethod.GET, requestEntity, CourseSummaryWrapper.class, new Object[0]);
        CourseSummaryWrapper summary = (CourseSummaryWrapper)((Object)response.getBody());
        return summary;
    }

    protected HttpEntity getRequestEntity(PortletRequest request) {
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        String username = (String)userInfo.get(this.usernameKey);
        String password = (String)userInfo.get(this.passwordKey);
        HttpHeaders requestHeaders = new HttpHeaders();
        String authString = username.concat(":").concat(password);
        String encodedAuthString = new Base64().encodeToString(authString.getBytes());
        requestHeaders.set("Authorization", "Basic ".concat(encodedAuthString));
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)requestHeaders);
        return requestEntity;
    }
}

