/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.courses.mvc.portlet;

import java.util.HashMap;
import javax.portlet.PortletRequest;
import org.jasig.portlet.courses.dao.ICoursesDao;
import org.jasig.portlet.courses.model.wrapper.CourseSummaryWrapper;
import org.jasig.portlet.courses.model.xml.Course;
import org.jasig.portlet.courses.model.xml.Instructor;
import org.jasig.portlet.courses.model.xml.Location;
import org.jasig.portlet.courses.mvc.IViewSelector;
import org.jasig.portlet.courses.service.IURLService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.ModelAndView;

@Controller
@RequestMapping(value={"VIEW"})
public class CoursesPortletController {
    private ICoursesDao coursesDao;
    private IURLService urlService;
    private IViewSelector viewSelector;

    @Autowired(required=true)
    public void setCoursesDao(ICoursesDao coursesDao) {
        this.coursesDao = coursesDao;
    }

    @Autowired(required=true)
    public void setUrlService(IURLService urlService) {
        this.urlService = urlService;
    }

    @Autowired(required=true)
    public void setViewSelector(IViewSelector viewSelector) {
        this.viewSelector = viewSelector;
    }

    @RequestMapping
    public ModelAndView getCourseList(PortletRequest request) {
        HashMap<String, CourseSummaryWrapper> model = new HashMap<String, CourseSummaryWrapper>();
        model.put("courseList", this.coursesDao.getSummary(request));
        boolean isMobile = this.viewSelector.isMobile(request);
        String viewName = isMobile ? "courseList-jQM" : "courseList";
        return new ModelAndView(viewName, model);
    }

    @RequestMapping(params={"action=showCourse"})
    public ModelAndView getCourseView(@RequestParam String courseCode, PortletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        CourseSummaryWrapper summary = this.coursesDao.getSummary(request);
        Course selectedCourse = null;
        for (Course course : summary.getCourses()) {
            if (!courseCode.equals(course.getCode())) continue;
            selectedCourse = course;
            break;
        }
        HashMap<String, String> instructorUrls = new HashMap<String, String>();
        for (Instructor instructor : selectedCourse.getInstructors()) {
            instructorUrls.put(instructor.getIdentifier(), this.urlService.getInstructorUrl(instructor, request));
        }
        model.put("instructorUrls", instructorUrls);
        Location location = selectedCourse.getLocation();
        if (location != null) {
            model.put("locationUrl", this.urlService.getLocationUrl(location, request));
        }
        model.put("course", selectedCourse);
        boolean isMobile = this.viewSelector.isMobile(request);
        String viewName = isMobile ? "courseDetail-jQM" : "courseDetail";
        return new ModelAndView(viewName, model);
    }
}

